/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.internal.observers.DeferredScalarDisposable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

public final class ObservableFromCompletionStage<T>
extends Observable<T> {
    final CompletionStage<T> stage;

    public ObservableFromCompletionStage(CompletionStage<T> stage) {
        this.stage = stage;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        BiConsumerAtomicReference whenReference = new BiConsumerAtomicReference();
        CompletionStageHandler<? super T> handler = new CompletionStageHandler<T>(observer, whenReference);
        whenReference.lazySet(handler);
        observer.onSubscribe(handler);
        this.stage.whenComplete(whenReference);
    }

    static final class BiConsumerAtomicReference<T>
    extends AtomicReference<BiConsumer<T, Throwable>>
    implements BiConsumer<T, Throwable> {
        private static final long serialVersionUID = 45838553147237545L;

        BiConsumerAtomicReference() {
        }

        @Override
        public void accept(T t, Throwable u) {
            BiConsumer biConsumer = (BiConsumer)this.get();
            if (biConsumer != null) {
                biConsumer.accept(t, u);
            }
        }
    }

    static final class CompletionStageHandler<T>
    extends DeferredScalarDisposable<T>
    implements BiConsumer<T, Throwable> {
        private static final long serialVersionUID = 4665335664328839859L;
        final BiConsumerAtomicReference<T> whenReference;

        CompletionStageHandler(Observer<? super T> downstream, BiConsumerAtomicReference<T> whenReference) {
            super(downstream);
            this.whenReference = whenReference;
        }

        @Override
        public void accept(T item, Throwable error) {
            if (error != null) {
                this.downstream.onError(error);
            } else if (item != null) {
                this.complete(item);
            } else {
                this.downstream.onError(new NullPointerException("The CompletionStage terminated with null."));
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            this.whenReference.set(null);
        }
    }
}

