/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.mixed;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.ErrorMode;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public final class FlowableConcatMapCompletable<T>
extends Completable {
    final Flowable<T> source;
    final Function<? super T, ? extends CompletableSource> mapper;
    final ErrorMode errorMode;
    final int prefetch;

    public FlowableConcatMapCompletable(Flowable<T> source, Function<? super T, ? extends CompletableSource> mapper, ErrorMode errorMode, int prefetch) {
        this.source = source;
        this.mapper = mapper;
        this.errorMode = errorMode;
        this.prefetch = prefetch;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe((FlowableSubscriber<? super T>)new ConcatMapCompletableObserver<T>(observer, this.mapper, this.errorMode, this.prefetch));
    }

    static final class ConcatMapCompletableObserver<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Disposable {
        private static final long serialVersionUID = 3610901111000061034L;
        final CompletableObserver downstream;
        final Function<? super T, ? extends CompletableSource> mapper;
        final ErrorMode errorMode;
        final AtomicThrowable errors;
        final ConcatMapInnerObserver inner;
        final int prefetch;
        final SimplePlainQueue<T> queue;
        Subscription upstream;
        volatile boolean active;
        volatile boolean done;
        volatile boolean disposed;
        int consumed;

        ConcatMapCompletableObserver(CompletableObserver downstream, Function<? super T, ? extends CompletableSource> mapper, ErrorMode errorMode, int prefetch) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.errorMode = errorMode;
            this.prefetch = prefetch;
            this.errors = new AtomicThrowable();
            this.inner = new ConcatMapInnerObserver(this);
            this.queue = new SpscArrayQueue<T>(prefetch);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                s.request((long)this.prefetch);
            }
        }

        public void onNext(T t) {
            if (this.queue.offer(t)) {
                this.drain();
            } else {
                this.upstream.cancel();
                this.onError(new MissingBackpressureException("Queue full?!"));
            }
        }

        public void onError(Throwable t) {
            if (this.errors.addThrowable(t)) {
                if (this.errorMode == ErrorMode.IMMEDIATE) {
                    this.inner.dispose();
                    t = this.errors.terminate();
                    if (t != ExceptionHelper.TERMINATED) {
                        this.downstream.onError(t);
                    }
                    if (this.getAndIncrement() == 0) {
                        this.queue.clear();
                    }
                } else {
                    this.done = true;
                    this.drain();
                }
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.upstream.cancel();
            this.inner.dispose();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        void innerError(Throwable ex) {
            if (this.errors.addThrowable(ex)) {
                if (this.errorMode == ErrorMode.IMMEDIATE) {
                    this.upstream.cancel();
                    ex = this.errors.terminate();
                    if (ex != ExceptionHelper.TERMINATED) {
                        this.downstream.onError(ex);
                    }
                    if (this.getAndIncrement() == 0) {
                        this.queue.clear();
                    }
                } else {
                    this.active = false;
                    this.drain();
                }
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            do {
                CompletableSource cs;
                boolean empty;
                if (this.disposed) {
                    this.queue.clear();
                    return;
                }
                if (this.active) continue;
                if (this.errorMode == ErrorMode.BOUNDARY && this.errors.get() != null) {
                    this.queue.clear();
                    Throwable ex = this.errors.terminate();
                    this.downstream.onError(ex);
                    return;
                }
                boolean d = this.done;
                T v = this.queue.poll();
                boolean bl = empty = v == null;
                if (d && empty) {
                    Throwable ex = this.errors.terminate();
                    if (ex != null) {
                        this.downstream.onError(ex);
                    } else {
                        this.downstream.onComplete();
                    }
                    return;
                }
                if (empty) continue;
                int c = this.consumed + 1;
                int limit = this.prefetch - (this.prefetch >> 1);
                if (c == limit) {
                    this.consumed = 0;
                    this.upstream.request((long)limit);
                } else {
                    this.consumed = c;
                }
                try {
                    cs = ObjectHelper.requireNonNull(this.mapper.apply(v), "The mapper returned a null CompletableSource");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.queue.clear();
                    this.upstream.cancel();
                    this.errors.addThrowable(ex);
                    ex = this.errors.terminate();
                    this.downstream.onError(ex);
                    return;
                }
                this.active = true;
                cs.subscribe(this.inner);
            } while (this.decrementAndGet() != 0);
        }

        static final class ConcatMapInnerObserver
        extends AtomicReference<Disposable>
        implements CompletableObserver {
            private static final long serialVersionUID = 5638352172918776687L;
            final ConcatMapCompletableObserver<?> parent;

            ConcatMapInnerObserver(ConcatMapCompletableObserver<?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.replace(this, d);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.innerError(e);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

