/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.testing.auth;

import java.util.List;
import org.apache.hc.client5.testing.auth.AuthenticationHandler;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolException;

abstract class AbstractAuthenticationHandler
implements AuthenticationHandler<String> {
    AbstractAuthenticationHandler() {
    }

    abstract String getSchemeName();

    @Override
    public final String challenge(List<NameValuePair> params) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getSchemeName());
        if (params != null && params.size() > 0) {
            buf.append(" ");
            for (int i = 0; i < params.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                NameValuePair param = params.get(i);
                buf.append(param.getName()).append("=\"").append(param.getValue()).append("\"");
            }
        }
        return buf.toString();
    }

    abstract String decodeChallenge(String var1);

    @Override
    public final String extractAuthToken(String challengeResponse) throws HttpException {
        int i = challengeResponse.indexOf(32);
        if (i == -1) {
            throw new ProtocolException("Invalid " + this.getSchemeName() + " challenge response");
        }
        String schemeName = challengeResponse.substring(0, i);
        if (schemeName.equalsIgnoreCase(this.getSchemeName())) {
            String s = challengeResponse.substring(i + 1).trim();
            try {
                return this.decodeChallenge(s);
            }
            catch (IllegalArgumentException ex) {
                throw new ProtocolException("Malformed " + this.getSchemeName() + " credentials");
            }
        }
        throw new ProtocolException("Unexpected challenge type");
    }
}

