/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import com.github.luben.zstd.ZstdDecompressCtx;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;

public final class InflatingZstdDataConsumer
implements AsyncDataConsumer {
    private static final int IN_BUF = 65536;
    private static final int OUT_BUF = 131072;
    private final AsyncDataConsumer downstream;
    private final ZstdDecompressCtx dctx = new ZstdDecompressCtx();
    private final ByteBuffer inDirect = ByteBuffer.allocateDirect(65536);
    private final ByteBuffer outDirect = ByteBuffer.allocateDirect(131072);
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public InflatingZstdDataConsumer(AsyncDataConsumer downstream) {
        this.downstream = downstream;
        this.inDirect.limit(0);
        this.outDirect.limit(0);
    }

    public void updateCapacity(CapacityChannel c) throws IOException {
        this.downstream.updateCapacity(c);
    }

    public void consume(ByteBuffer src) throws IOException {
        if (this.closed.get()) {
            return;
        }
        block0: while (src.hasRemaining()) {
            this.inDirect.compact();
            int take = Math.min(this.inDirect.remaining(), src.remaining());
            int oldLimit = src.limit();
            src.limit(src.position() + take);
            this.inDirect.put(src);
            src.limit(oldLimit);
            this.inDirect.flip();
            while (this.inDirect.hasRemaining()) {
                this.outDirect.compact();
                this.dctx.decompressDirectByteBufferStream(this.outDirect, this.inDirect);
                this.outDirect.flip();
                if (!this.outDirect.hasRemaining()) continue block0;
                this.downstream.consume(this.outDirect);
                if (!this.outDirect.hasRemaining()) continue;
                return;
            }
        }
    }

    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.dctx.close();
            this.downstream.streamEnd(trailers);
        }
    }

    public void releaseResources() {
        this.dctx.close();
        this.downstream.releaseResources();
    }
}

