/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public enum TxState {
    PENDING,
    FINISHING,
    ABORTED,
    COMMITTED,
    ABANDONED;

    private static final boolean[][] TRANSITION_MATRIX;
    private static final TxState[] VALUES;

    public static boolean isFinalState(TxState state) {
        return state == COMMITTED || state == ABORTED;
    }

    public static boolean checkTransitionCorrectness(@Nullable TxState before, TxState after) {
        Objects.requireNonNull(after);
        int beforeOrd = before == null ? 0 : before.ordinal() + 1;
        int afterOrd = after.ordinal() + 1;
        return TRANSITION_MATRIX[beforeOrd][afterOrd];
    }

    public static TxState fromOrdinal(int ordinal) throws IllegalArgumentException {
        if (ordinal < 0 || ordinal >= VALUES.length) {
            throw new IllegalArgumentException("No enum constant from ordinal: " + ordinal);
        }
        return VALUES[ordinal];
    }

    static {
        TRANSITION_MATRIX = new boolean[][]{{false, true, true, true, true, true}, {false, true, true, true, true, true}, {false, false, false, true, true, true}, {false, false, false, true, false, false}, {false, false, false, false, true, false}, {false, false, true, true, true, true}};
        VALUES = TxState.values();
    }
}

