/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.storage.state;

import org.apache.ignite.internal.tx.storage.state.ThreadAssertingTxStateStorage;
import org.apache.ignite.internal.tx.storage.state.TxStateStorage;
import org.apache.ignite.internal.tx.storage.state.TxStateTableStorage;
import org.apache.ignite.internal.worker.ThreadAssertions;
import org.jetbrains.annotations.Nullable;

public class ThreadAssertingTxStateTableStorage
implements TxStateTableStorage {
    private final TxStateTableStorage tableStorage;

    public ThreadAssertingTxStateTableStorage(TxStateTableStorage tableStorage) {
        this.tableStorage = tableStorage;
    }

    @Override
    public TxStateStorage getOrCreateTxStateStorage(int partitionId) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return new ThreadAssertingTxStateStorage(this.tableStorage.getOrCreateTxStateStorage(partitionId));
    }

    @Override
    @Nullable
    public TxStateStorage getTxStateStorage(int partitionId) {
        TxStateStorage storage = this.tableStorage.getTxStateStorage(partitionId);
        return storage == null ? null : new ThreadAssertingTxStateStorage(storage);
    }

    @Override
    public void destroyTxStateStorage(int partitionId) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.tableStorage.destroyTxStateStorage(partitionId);
    }

    @Override
    public void start() {
        this.tableStorage.start();
    }

    @Override
    public void stop() {
        this.tableStorage.stop();
    }

    @Override
    public void close() {
        this.tableStorage.close();
    }

    @Override
    public void destroy() {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.tableStorage.destroy();
    }
}

