/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.DistributionZoneNotFoundValidationException;
import org.apache.ignite.internal.catalog.IndexNotFoundValidationException;
import org.apache.ignite.internal.catalog.TableNotFoundValidationException;
import org.apache.ignite.internal.catalog.commands.ColumnParams;
import org.apache.ignite.internal.catalog.commands.DefaultValue;
import org.apache.ignite.internal.catalog.commands.StorageProfileParams;
import org.apache.ignite.internal.catalog.commands.TypeChangeValidationListener;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogStorageProfileDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogStorageProfilesDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.descriptors.ConsistencyMode;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class CatalogUtils {
    public static final int DEFAULT_PARTITION_COUNT = 25;
    public static final int DEFAULT_REPLICA_COUNT = 1;
    public static final String DEFAULT_FILTER = "$..*";
    public static final int INFINITE_TIMER_VALUE = Integer.MAX_VALUE;
    public static final int IMMEDIATE_TIMER_VALUE = 0;
    public static final int MAX_PARTITION_COUNT = 65000;
    public static final int DEFAULT_PRECISION = 0;
    public static final int DEFAULT_SCALE = 0;
    public static final int MAX_TIME_PRECISION = 9;
    public static final int MAX_DECIMAL_PRECISION = Short.MAX_VALUE;
    public static final int MAX_DECIMAL_SCALE = Short.MAX_VALUE;
    public static final int DEFAULT_LENGTH = 1;
    public static final int DEFAULT_VARLEN_LENGTH = 65536;
    public static final ConsistencyMode DEFAULT_CONSISTENCY_MODE = ConsistencyMode.STRONG_CONSISTENCY;
    private static final Map<ColumnType, Set<ColumnType>> ALTER_COLUMN_TYPE_TRANSITIONS = new EnumMap<ColumnType, Set<ColumnType>>(ColumnType.class);
    private static final Map<String, ColumnType> FUNCTIONAL_DEFAULT_FUNCTIONS = new HashMap<String, ColumnType>();
    public static final Set<String> SYSTEM_SCHEMAS;

    public static boolean isSystemSchema(String schemaName) {
        return SYSTEM_SCHEMAS.contains(schemaName);
    }

    public static CatalogStorageProfilesDescriptor fromParams(List<StorageProfileParams> params) {
        return new CatalogStorageProfilesDescriptor(params.stream().map(p -> new CatalogStorageProfileDescriptor(p.storageProfile())).collect(Collectors.toList()));
    }

    public static CatalogTableColumnDescriptor fromParams(ColumnParams params) {
        int precision = Objects.requireNonNullElse(params.precision(), 0);
        int scale = Objects.requireNonNullElse(params.scale(), 0);
        int length = Objects.requireNonNullElse(params.length(), CatalogUtils.defaultLength(params.type(), precision));
        Object defaultValue = params.defaultValueDefinition();
        return new CatalogTableColumnDescriptor(params.name(), params.type(), params.nullable(), precision, scale, length, (DefaultValue)defaultValue);
    }

    public static boolean isSupportedColumnTypeChange(ColumnType source, ColumnType target) {
        Set<ColumnType> supportedTransitions = ALTER_COLUMN_TYPE_TRANSITIONS.get(source);
        return supportedTransitions != null && supportedTransitions.contains(target);
    }

    public static boolean validateColumnChange(CatalogTableColumnDescriptor origin, @Nullable ColumnType newType, @Nullable Integer newPrecision, @Nullable Integer newScale, @Nullable Integer newLength, TypeChangeValidationListener listener) {
        if (newType != null) {
            if (CatalogUtils.isSupportedColumnTypeChange(origin.type(), newType)) {
                if (origin.type().precisionAllowed() && newPrecision != null && newPrecision < origin.precision()) {
                    listener.onFailure("Decreasing the precision for column of type '{}' is not allowed", origin.type(), newType);
                    return false;
                }
                if (origin.type().scaleAllowed() && newScale != null && newScale.intValue() != origin.scale()) {
                    listener.onFailure("Changing the scale for column of type '{}' is not allowed", origin.type(), newType);
                    return false;
                }
                if (origin.type().lengthAllowed() && newLength != null && newLength < origin.length()) {
                    listener.onFailure("Decreasing the length for column of type '{}' is not allowed", origin.type(), newType);
                    return false;
                }
                return true;
            }
            if (newType != origin.type()) {
                listener.onFailure("Changing the type from {} to {} is not allowed", origin.type(), newType);
                return false;
            }
        }
        if (newPrecision != null && newPrecision.intValue() != origin.precision()) {
            listener.onFailure("Changing the precision for column of type '{}' is not allowed", origin.type(), newType);
            return false;
        }
        if (newScale != null && newScale.intValue() != origin.scale()) {
            listener.onFailure("Changing the scale for column of type '{}' is not allowed", origin.type(), newType);
            return false;
        }
        if (newLength != null && newLength.intValue() != origin.length()) {
            listener.onFailure("Changing the length for column of type '{}' is not allowed", origin.type(), newType);
            return false;
        }
        return true;
    }

    public static boolean isColumnTypeChangeSupported(CatalogTableColumnDescriptor oldColumn, CatalogTableColumnDescriptor newColumn) {
        return CatalogUtils.validateColumnChange(oldColumn, newColumn.type(), newColumn.precision(), newColumn.scale(), newColumn.length(), TypeChangeValidationListener.NO_OP);
    }

    public static List<CatalogSchemaDescriptor> replaceSchema(CatalogSchemaDescriptor newSchema, Collection<CatalogSchemaDescriptor> schemas) {
        return schemas.stream().map(s -> {
            if (Objects.equals(s.id(), newSchema.id())) {
                return newSchema;
            }
            return s;
        }).collect(Collectors.toList());
    }

    public static CatalogSchemaDescriptor replaceTable(CatalogSchemaDescriptor schema, CatalogTableDescriptor newTableDescriptor) {
        CatalogTableDescriptor[] tableDescriptors = (CatalogTableDescriptor[])schema.tables().clone();
        for (int i = 0; i < tableDescriptors.length; ++i) {
            if (tableDescriptors[i].id() != newTableDescriptor.id()) continue;
            tableDescriptors[i] = newTableDescriptor;
            return new CatalogSchemaDescriptor(schema.id(), schema.name(), tableDescriptors, schema.indexes(), schema.systemViews(), newTableDescriptor.updateToken());
        }
        throw new CatalogValidationException(String.format("Table with ID %d has not been found in schema with ID %d", newTableDescriptor.id(), newTableDescriptor.schemaId()));
    }

    public static CatalogSchemaDescriptor replaceIndex(CatalogSchemaDescriptor schema, CatalogIndexDescriptor newIndexDescriptor) {
        CatalogIndexDescriptor[] indexDescriptors = (CatalogIndexDescriptor[])schema.indexes().clone();
        for (int i = 0; i < indexDescriptors.length; ++i) {
            if (indexDescriptors[i].id() != newIndexDescriptor.id()) continue;
            indexDescriptors[i] = newIndexDescriptor;
            return new CatalogSchemaDescriptor(schema.id(), schema.name(), schema.tables(), indexDescriptors, schema.systemViews(), newIndexDescriptor.updateToken());
        }
        throw new CatalogValidationException(String.format("Index with ID %d has not been found in schema with ID %d", newIndexDescriptor.id(), schema.id()));
    }

    public static int defaultLength(ColumnType columnType, int precision) {
        switch (columnType) {
            case STRING: 
            case BYTE_ARRAY: {
                return 65536;
            }
        }
        return Math.max(1, precision);
    }

    public static CatalogSchemaDescriptor schemaOrThrow(Catalog catalog, String name) throws CatalogValidationException {
        CatalogSchemaDescriptor schema = catalog.schema(name = Objects.requireNonNull(name, "schemaName"));
        if (schema == null) {
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"Schema with name '{}' not found", (Object[])new Object[]{name}));
        }
        return schema;
    }

    public static CatalogSchemaDescriptor schemaOrThrow(Catalog catalog, int schemaId) throws CatalogValidationException {
        CatalogSchemaDescriptor schema = catalog.schema(schemaId);
        if (schema == null) {
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"Schema with ID '{}' not found", (Object[])new Object[]{schemaId}));
        }
        return schema;
    }

    public static CatalogTableDescriptor tableOrThrow(CatalogSchemaDescriptor schema, String name) throws TableNotFoundValidationException {
        CatalogTableDescriptor table = schema.table(name = Objects.requireNonNull(name, "tableName"));
        if (table == null) {
            throw new TableNotFoundValidationException(IgniteStringFormatter.format((String)"Table with name '{}.{}' not found", (Object[])new Object[]{schema.name(), name}));
        }
        return table;
    }

    public static CatalogTableDescriptor tableOrThrow(Catalog catalog, int tableId) throws TableNotFoundValidationException {
        CatalogTableDescriptor table = catalog.table(tableId);
        if (table == null) {
            throw new TableNotFoundValidationException(IgniteStringFormatter.format((String)"Table with ID '{}' not found", (Object[])new Object[]{tableId}));
        }
        return table;
    }

    public static CatalogZoneDescriptor zoneOrThrow(Catalog catalog, String name) throws DistributionZoneNotFoundValidationException {
        CatalogZoneDescriptor zone = catalog.zone(name = Objects.requireNonNull(name, "zoneName"));
        if (zone == null) {
            throw new DistributionZoneNotFoundValidationException(IgniteStringFormatter.format((String)"Distribution zone with name '{}' not found", (Object[])new Object[]{name}));
        }
        return zone;
    }

    public static String pkIndexName(String tableName) {
        return tableName + "_PK";
    }

    public static CatalogIndexDescriptor indexOrThrow(CatalogSchemaDescriptor schema, String name) throws IndexNotFoundValidationException {
        CatalogIndexDescriptor index = schema.aliveIndex(name);
        if (index == null) {
            throw new IndexNotFoundValidationException(IgniteStringFormatter.format((String)"Index with name '{}.{}' not found", (Object[])new Object[]{schema.name(), name}));
        }
        return index;
    }

    public static CatalogIndexDescriptor indexOrThrow(Catalog catalog, int indexId) throws IndexNotFoundValidationException {
        CatalogIndexDescriptor index = catalog.index(indexId);
        if (index == null) {
            throw new IndexNotFoundValidationException(IgniteStringFormatter.format((String)"Index with ID '{}' not found", (Object[])new Object[]{indexId}));
        }
        return index;
    }

    public static HybridTimestamp clusterWideEnsuredActivationTimestamp(long activationTs, long maxClockSkewMillis) {
        return HybridTimestamp.hybridTimestamp((long)activationTs).addPhysicalTime(maxClockSkewMillis).roundUpToPhysicalTick();
    }

    @Nullable
    public static Integer defaultZoneIdOpt(Catalog catalog) {
        CatalogZoneDescriptor defaultZone = catalog.defaultZone();
        return defaultZone != null ? Integer.valueOf(defaultZone.id()) : null;
    }

    static void ensureSupportedDefault(String columnName, ColumnType columnType, @Nullable DefaultValue defaultValue) {
        if (defaultValue == null || defaultValue.type == DefaultValue.Type.CONSTANT) {
            return;
        }
        if (defaultValue.type == DefaultValue.Type.FUNCTION_CALL) {
            String functionName = ((DefaultValue.FunctionCall)defaultValue).functionName();
            ColumnType returnType = FUNCTIONAL_DEFAULT_FUNCTIONS.get(functionName.toUpperCase());
            if (returnType == columnType) {
                return;
            }
            if (returnType != null) {
                throw new CatalogValidationException(IgniteStringFormatter.format((String)"Functional default type mismatch: [col={}, functionName={}, expectedType={}, actualType={}]", (Object[])new Object[]{columnName, functionName, returnType, columnType}));
            }
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"Functional default contains unsupported function: [col={}, functionName={}]", (Object[])new Object[]{columnName, functionName}));
        }
        throw new CatalogValidationException(IgniteStringFormatter.format((String)"Default of unsupported kind: [col={}, defaultType={}]", (Object[])new Object[]{columnName, defaultValue.type}));
    }

    static void ensureNonFunctionalDefault(String columnName, @Nullable DefaultValue defaultValue) {
        if (defaultValue == null || defaultValue.type == DefaultValue.Type.CONSTANT) {
            return;
        }
        if (defaultValue.type == DefaultValue.Type.FUNCTION_CALL) {
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"Functional defaults are not supported for non-primary key columns [col={}].", (Object[])new Object[]{columnName}));
        }
        throw new CatalogValidationException(IgniteStringFormatter.format((String)"Default of unsupported kind: [col={}, defaultType={}]", (Object[])new Object[]{columnName, defaultValue.type}));
    }

    static void ensureTypeCanBeStored(String columnName, ColumnType columnType) {
        if (columnType == ColumnType.PERIOD || columnType == ColumnType.DURATION) {
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"Column of type '{}' cannot be persisted [col={}].", (Object[])new Object[]{columnType, columnName}));
        }
    }

    static {
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.INT8, EnumSet.of(ColumnType.INT8, ColumnType.INT16, ColumnType.INT32, ColumnType.INT64));
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.INT16, EnumSet.of(ColumnType.INT16, ColumnType.INT32, ColumnType.INT64));
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.INT32, EnumSet.of(ColumnType.INT32, ColumnType.INT64));
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.INT64, EnumSet.of(ColumnType.INT64));
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.FLOAT, EnumSet.of(ColumnType.FLOAT, ColumnType.DOUBLE));
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.DOUBLE, EnumSet.of(ColumnType.DOUBLE));
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.STRING, EnumSet.of(ColumnType.STRING));
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.BYTE_ARRAY, EnumSet.of(ColumnType.BYTE_ARRAY));
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.DECIMAL, EnumSet.of(ColumnType.DECIMAL));
        FUNCTIONAL_DEFAULT_FUNCTIONS.put("RAND_UUID", ColumnType.UUID);
        SYSTEM_SCHEMAS = Set.of("SYSTEM", "DEFINITION_SCHEMA", "INFORMATION_SCHEMA");
    }
}

