/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.DistributionZoneExistsValidationException;
import org.apache.ignite.internal.catalog.commands.AbstractZoneCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.CreateZoneCommandBuilder;
import org.apache.ignite.internal.catalog.commands.StorageProfileParams;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.descriptors.ConsistencyMode;
import org.apache.ignite.internal.catalog.storage.NewZoneEntry;
import org.apache.ignite.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.jetbrains.annotations.Nullable;

public class CreateZoneCommand
extends AbstractZoneCommand {
    private final boolean ifNotExists;
    @Nullable
    private final Integer partitions;
    @Nullable
    private final Integer replicas;
    @Nullable
    private final Integer dataNodesAutoAdjust;
    @Nullable
    private final Integer dataNodesAutoAdjustScaleUp;
    @Nullable
    private final Integer dataNodesAutoAdjustScaleDown;
    @Nullable
    private final String filter;
    private final List<StorageProfileParams> storageProfileParams;
    @Nullable
    private final ConsistencyMode consistencyMode;

    public static CreateZoneCommandBuilder builder() {
        return new Builder();
    }

    private CreateZoneCommand(String zoneName, boolean ifNotExists, @Nullable Integer partitions, @Nullable Integer replicas, @Nullable Integer dataNodesAutoAdjust, @Nullable Integer dataNodesAutoAdjustScaleUp, @Nullable Integer dataNodesAutoAdjustScaleDown, @Nullable String filter, List<StorageProfileParams> storageProfileParams, @Nullable ConsistencyMode consistencyMode) throws CatalogValidationException {
        super(zoneName);
        this.ifNotExists = ifNotExists;
        this.partitions = partitions;
        this.replicas = replicas;
        this.dataNodesAutoAdjust = dataNodesAutoAdjust;
        this.dataNodesAutoAdjustScaleUp = dataNodesAutoAdjustScaleUp;
        this.dataNodesAutoAdjustScaleDown = dataNodesAutoAdjustScaleDown;
        this.filter = filter;
        this.storageProfileParams = storageProfileParams;
        this.consistencyMode = consistencyMode;
        this.validate();
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public List<UpdateEntry> get(Catalog catalog) {
        if (catalog.zone(this.zoneName) != null) {
            throw new DistributionZoneExistsValidationException(IgniteStringFormatter.format((String)"Distribution zone with name '{}' already exists", (Object[])new Object[]{this.zoneName}));
        }
        CatalogZoneDescriptor zoneDesc = this.descriptor(catalog.objectIdGenState());
        return List.of(new NewZoneEntry(zoneDesc), new ObjectIdGenUpdateEntry(1));
    }

    private CatalogZoneDescriptor descriptor(int objectId) {
        CatalogZoneDescriptor zone = new CatalogZoneDescriptor(objectId, this.zoneName, Objects.requireNonNullElse(this.partitions, 25), Objects.requireNonNullElse(this.replicas, 1), Objects.requireNonNullElse(this.dataNodesAutoAdjust, Integer.MAX_VALUE), Objects.requireNonNullElse(this.dataNodesAutoAdjustScaleUp, this.dataNodesAutoAdjust != null ? Integer.MAX_VALUE : 0), Objects.requireNonNullElse(this.dataNodesAutoAdjustScaleDown, Integer.MAX_VALUE), Objects.requireNonNullElse(this.filter, "$..*"), CatalogUtils.fromParams(this.storageProfileParams), Objects.requireNonNullElse(this.consistencyMode, ConsistencyMode.STRONG_CONSISTENCY));
        return zone;
    }

    private void validate() {
        CatalogParamsValidationUtils.validateField(this.partitions, 1, 65000, "Invalid number of partitions");
        CatalogParamsValidationUtils.validateField(this.replicas, 1, null, "Invalid number of replicas");
        CatalogParamsValidationUtils.validateField(this.dataNodesAutoAdjust, 0, null, "Invalid data nodes auto adjust");
        CatalogParamsValidationUtils.validateField(this.dataNodesAutoAdjustScaleUp, 0, null, "Invalid data nodes auto adjust scale up");
        CatalogParamsValidationUtils.validateField(this.dataNodesAutoAdjustScaleDown, 0, null, "Invalid data nodes auto adjust scale down");
        CatalogParamsValidationUtils.validateZoneDataNodesAutoAdjustParametersCompatibility(this.dataNodesAutoAdjust, this.dataNodesAutoAdjustScaleUp, this.dataNodesAutoAdjustScaleDown);
        CatalogParamsValidationUtils.validateZoneFilter(this.filter);
        CatalogParamsValidationUtils.validateConsistencyMode(this.consistencyMode);
        CatalogParamsValidationUtils.validateStorageProfiles(this.storageProfileParams);
    }

    private static class Builder
    implements CreateZoneCommandBuilder {
        private String zoneName;
        private boolean ifNotExists;
        @Nullable
        private Integer partitions;
        @Nullable
        private Integer replicas;
        @Nullable
        private Integer dataNodesAutoAdjust;
        @Nullable
        private Integer dataNodesAutoAdjustScaleUp;
        @Nullable
        private Integer dataNodesAutoAdjustScaleDown;
        @Nullable
        private String filter;
        @Nullable
        private ConsistencyMode consistencyMode;
        private List<StorageProfileParams> storageProfileParams;

        private Builder() {
        }

        @Override
        public CreateZoneCommandBuilder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder ifNotExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder partitions(Integer partitions) {
            this.partitions = partitions;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder replicas(Integer replicas) {
            this.replicas = replicas;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder dataNodesAutoAdjust(Integer adjust) {
            this.dataNodesAutoAdjust = adjust;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder dataNodesAutoAdjustScaleUp(Integer adjust) {
            this.dataNodesAutoAdjustScaleUp = adjust;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder dataNodesAutoAdjustScaleDown(Integer adjust) {
            this.dataNodesAutoAdjustScaleDown = adjust;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder storageProfilesParams(List<StorageProfileParams> params) {
            this.storageProfileParams = params;
            return this;
        }

        @Override
        public CreateZoneCommandBuilder consistencyModeParams(@Nullable ConsistencyMode params) {
            this.consistencyMode = params;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new CreateZoneCommand(this.zoneName, this.ifNotExists, this.partitions, this.replicas, this.dataNodesAutoAdjust, this.dataNodesAutoAdjustScaleUp, this.dataNodesAutoAdjustScaleDown, this.filter, this.storageProfileParams, this.consistencyMode);
        }
    }
}

