/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.events.AlterZoneEventParameters;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class AlterZoneEntry
implements UpdateEntry,
Fireable {
    public static final CatalogObjectSerializer<AlterZoneEntry> SERIALIZER = new AlterZoneEntrySerializer();
    private final CatalogZoneDescriptor descriptor;

    public AlterZoneEntry(CatalogZoneDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public CatalogZoneDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.ALTER_ZONE.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.ZONE_ALTER;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new AlterZoneEventParameters(causalityToken, catalogVersion, this.descriptor);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, long causalityToken) {
        this.descriptor.updateToken(causalityToken);
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones().stream().map(z -> z.id() == this.descriptor.id() ? this.descriptor : z).collect(Collectors.toList()), catalog.schemas(), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class AlterZoneEntrySerializer
    implements CatalogObjectSerializer<AlterZoneEntry> {
        private AlterZoneEntrySerializer() {
        }

        @Override
        public AlterZoneEntry readFrom(IgniteDataInput input) throws IOException {
            CatalogZoneDescriptor descriptor = CatalogZoneDescriptor.SERIALIZER.readFrom(input);
            return new AlterZoneEntry(descriptor);
        }

        @Override
        public void writeTo(AlterZoneEntry object, IgniteDataOutput output) throws IOException {
            CatalogZoneDescriptor.SERIALIZER.writeTo(object.descriptor(), output);
        }
    }
}

