/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import java.util.UUID;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.tree.IgniteTree;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.TxIdMismatchException;
import org.apache.ignite.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChain;
import org.jetbrains.annotations.Nullable;

class AddWriteInvokeClosure
implements IgniteTree.InvokeClosure<VersionChain> {
    private final RowId rowId;
    @Nullable
    private final BinaryRow row;
    private final UUID txId;
    private final int commitTableId;
    private final int commitPartitionId;
    private final AbstractPageMemoryMvPartitionStorage storage;
    @Nullable
    private VersionChain newRow;
    @Nullable
    private BinaryRow previousUncommittedRowVersion;
    @Nullable
    private RowVersion toRemove;

    AddWriteInvokeClosure(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitTableId, int commitPartitionId, AbstractPageMemoryMvPartitionStorage storage) {
        this.rowId = rowId;
        this.row = row;
        this.txId = txId;
        this.commitTableId = commitTableId;
        this.commitPartitionId = commitPartitionId;
        this.storage = storage;
    }

    public void call(@Nullable VersionChain oldRow) throws IgniteInternalCheckedException {
        if (oldRow == null) {
            RowVersion newVersion = this.insertRowVersion(this.row, 0L);
            this.newRow = VersionChain.createUncommitted(this.rowId, this.txId, this.commitTableId, this.commitPartitionId, newVersion.link(), 0L);
            return;
        }
        if (oldRow.isUncommitted()) {
            this.throwIfChainBelongsToAnotherTx(oldRow);
        }
        RowVersion newVersion = this.insertRowVersion(this.row, oldRow.newestCommittedLink());
        if (oldRow.isUncommitted()) {
            RowVersion currentVersion = this.storage.readRowVersion(oldRow.headLink(), AbstractPageMemoryMvPartitionStorage.ALWAYS_LOAD_VALUE);
            this.previousUncommittedRowVersion = currentVersion.value();
            this.toRemove = currentVersion;
        }
        this.newRow = VersionChain.createUncommitted(this.rowId, this.txId, this.commitTableId, this.commitPartitionId, newVersion.link(), newVersion.nextLink());
    }

    @Nullable
    public VersionChain newRow() {
        assert (this.newRow != null);
        return this.newRow;
    }

    public IgniteTree.OperationType operationType() {
        return IgniteTree.OperationType.PUT;
    }

    @Nullable
    BinaryRow getPreviousUncommittedRowVersion() {
        return this.previousUncommittedRowVersion;
    }

    private RowVersion insertRowVersion(@Nullable BinaryRow row, long nextPartitionlessLink) {
        RowVersion rowVersion = new RowVersion(this.storage.partitionId, nextPartitionlessLink, row);
        this.storage.insertRowVersion(rowVersion);
        return rowVersion;
    }

    private void throwIfChainBelongsToAnotherTx(VersionChain versionChain) {
        assert (versionChain.isUncommitted());
        if (!this.txId.equals(versionChain.transactionId())) {
            throw new TxIdMismatchException(this.txId, versionChain.transactionId());
        }
    }

    void afterCompletion() {
        if (this.toRemove != null) {
            this.storage.removeRowVersion(this.toRemove);
        }
    }
}

