/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.op;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.amoro.hive.HMSClientPool;
import org.apache.amoro.hive.exceptions.CannotAlterHiveLocationException;
import org.apache.amoro.hive.table.UnkeyedHiveTable;
import org.apache.amoro.hive.utils.HiveCommitUtil;
import org.apache.amoro.hive.utils.HiveMetaSynchronizer;
import org.apache.amoro.hive.utils.HivePartitionUtil;
import org.apache.amoro.hive.utils.HiveTableUtil;
import org.apache.amoro.io.AuthenticatedHadoopFileIO;
import org.apache.amoro.op.UpdatePartitionProperties;
import org.apache.amoro.shade.guava32.com.google.common.base.Joiner;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.utils.TableFileUtil;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeMap;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpdateHiveFiles<T extends SnapshotUpdate<T>>
implements SnapshotUpdate<T> {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateHiveFiles.class);
    public static final String PROPERTIES_VALIDATE_LOCATION = "validate-location";
    public static final String DELETE_UNTRACKED_HIVE_FILE = "delete-untracked-hive-file";
    public static final String SYNC_DATA_TO_HIVE = "sync-data-to-hive";
    protected final Transaction transaction;
    protected final boolean insideTransaction;
    protected final UnkeyedHiveTable table;
    protected final HMSClientPool hmsClient;
    protected final HMSClientPool transactionClient;
    protected final T delegate;
    protected final String db;
    protected final String tableName;
    protected final Table hiveTable;
    protected Expression expr;
    protected final List<DataFile> addFiles = Lists.newArrayList();
    protected final List<DataFile> deleteFiles = Lists.newArrayList();
    protected StructLikeMap<Partition> partitionToDelete;
    protected StructLikeMap<Partition> partitionToCreate;
    protected final StructLikeMap<Partition> partitionToAlter;
    protected final StructLikeMap<Partition> partitionToAlterLocation;
    protected String unpartitionTableLocation;
    private String hiveLocation = null;
    protected Long txId = null;
    protected boolean validateLocation = true;
    protected boolean checkOrphanFiles = false;
    protected boolean syncDataToHive = false;
    protected int commitTimestamp;

    public UpdateHiveFiles(Transaction transaction, boolean insideTransaction, UnkeyedHiveTable table, T delegate, HMSClientPool hmsClient, HMSClientPool transactionClient) {
        this.transaction = transaction;
        this.insideTransaction = insideTransaction;
        this.table = table;
        this.delegate = delegate;
        this.hmsClient = hmsClient;
        this.transactionClient = transactionClient;
        this.db = table.id().getDatabase();
        this.tableName = table.id().getTableName();
        try {
            this.hiveTable = (Table)hmsClient.run(c -> c.getTable(this.db, this.tableName));
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException(e);
        }
        this.partitionToAlter = StructLikeMap.create((Types.StructType)table.spec().partitionType());
        this.partitionToCreate = StructLikeMap.create((Types.StructType)table.spec().partitionType());
        this.partitionToDelete = StructLikeMap.create((Types.StructType)table.spec().partitionType());
        this.partitionToAlterLocation = StructLikeMap.create((Types.StructType)table.spec().partitionType());
    }

    private String hiveLocation() {
        if (this.hiveLocation == null) {
            this.hiveLocation = this.table.hiveLocation();
        }
        return this.hiveLocation;
    }

    protected abstract void postHiveDataCommitted(List<DataFile> var1);

    public void commit() {
        this.commitTimestamp = (int)(System.currentTimeMillis() / 1000L);
        this.applyDeleteExpr();
        if (this.syncDataToHive) {
            HiveMetaSynchronizer.syncMixedTableDataToHive(this.table);
        }
        List<DataFile> committedDataFiles = HiveCommitUtil.commitConsistentWriteFiles(this.addFiles, this.table.io(), this.table.spec());
        this.addFiles.clear();
        this.addFiles.addAll(committedDataFiles);
        this.postHiveDataCommitted(this.addFiles);
        if (this.table.spec().isUnpartitioned()) {
            this.generateUnpartitionTableLocation();
        } else {
            this.partitionToDelete = this.getDeletePartition();
            this.partitionToCreate = this.getCreatePartition(this.partitionToDelete);
        }
        if (this.checkOrphanFiles) {
            this.checkPartitionedOrphanFilesAndDelete(this.table.spec().isUnpartitioned());
        }
        boolean noHiveDataFilesChanged = CollectionUtils.isEmpty(this.addFiles) && CollectionUtils.isEmpty(this.deleteFiles) && this.expr != Expressions.alwaysTrue();
        this.delegate.commit();
        if (!noHiveDataFilesChanged) {
            this.commitPartitionProperties();
        }
        if (!this.insideTransaction) {
            this.transaction.commitTransaction();
        }
        if (noHiveDataFilesChanged) {
            return;
        }
        try {
            if (this.table.spec().isUnpartitioned()) {
                this.commitNonPartitionedTable();
            } else {
                this.commitPartitionedTable();
            }
        }
        catch (Exception e) {
            LOG.warn("Commit operation to HMS failed.", (Throwable)e);
        }
    }

    private void commitPartitionProperties() {
        UpdatePartitionProperties updatePartitionProperties = this.table.updatePartitionProperties(this.transaction);
        if (this.table.spec().isUnpartitioned()) {
            updatePartitionProperties.set(TablePropertyUtil.EMPTY_STRUCT, "hive-location", this.unpartitionTableLocation);
            updatePartitionProperties.set(TablePropertyUtil.EMPTY_STRUCT, "transient-time", this.commitTimestamp + "");
        } else {
            this.partitionToDelete.forEach((partitionData, partition) -> {
                if (!this.partitionToCreate.containsKey(partitionData)) {
                    updatePartitionProperties.remove(partitionData, "hive-location");
                    updatePartitionProperties.remove(partitionData, "transient-time");
                }
            });
            this.partitionToCreate.forEach((partitionData, partition) -> {
                updatePartitionProperties.set(partitionData, "hive-location", partition.getSd().getLocation());
                updatePartitionProperties.set(partitionData, "transient-time", this.commitTimestamp + "");
            });
            this.partitionToAlter.forEach((partitionData, partition) -> {
                updatePartitionProperties.set(partitionData, "hive-location", partition.getSd().getLocation());
                updatePartitionProperties.set(partitionData, "transient-time", this.commitTimestamp + "");
            });
        }
        updatePartitionProperties.commit();
    }

    protected StructLikeMap<Partition> getCreatePartition(StructLikeMap<Partition> partitionToDelete) {
        String location;
        if (this.addFiles.isEmpty()) {
            return StructLikeMap.create((Types.StructType)this.table.spec().partitionType());
        }
        HashMap partitionLocationMap = Maps.newHashMap();
        HashMap partitionDataFileMap = Maps.newHashMap();
        HashMap partitionValueMap = Maps.newHashMap();
        Types.StructType partitionSchema = this.table.spec().partitionType();
        for (DataFile d : this.addFiles) {
            List<String> partitionValues = HivePartitionUtil.partitionValuesAsList(d.partition(), partitionSchema);
            String value = Joiner.on((String)"/").join(partitionValues);
            location = TableFileUtil.getFileDir((String)d.path().toString());
            partitionLocationMap.put(value, location);
            if (!partitionDataFileMap.containsKey(value)) {
                partitionDataFileMap.put(value, Lists.newArrayList());
            }
            ((List)partitionDataFileMap.get(value)).add(d);
            partitionValueMap.put(value, partitionValues);
        }
        StructLikeMap<Partition> createPartitions = StructLikeMap.create((Types.StructType)this.table.spec().partitionType());
        for (String val : partitionValueMap.keySet()) {
            List values = (List)partitionValueMap.get(val);
            location = (String)partitionLocationMap.get(val);
            List dataFiles = (List)partitionDataFileMap.get(val);
            this.checkCreatePartitionDataFiles(dataFiles, location);
            Partition p = HivePartitionUtil.newPartition(this.hiveTable, values, location, dataFiles, this.commitTimestamp);
            createPartitions.put(((DataFile)dataFiles.get(0)).partition(), (Object)p);
        }
        createPartitions = this.filterNewPartitionNonExists(createPartitions, partitionToDelete);
        return createPartitions;
    }

    protected StructLikeMap<Partition> getDeletePartition() {
        StructLikeMap deletePartitions = StructLikeMap.create((Types.StructType)this.table.spec().partitionType());
        if (this.deleteFiles.isEmpty()) {
            return deletePartitions;
        }
        Types.StructType partitionSchema = this.table.spec().partitionType();
        HashSet checkedPartitionValues = Sets.newHashSet();
        HashSet deleteFileLocations = Sets.newHashSet();
        for (DataFile dataFile : this.deleteFiles) {
            List<String> values = HivePartitionUtil.partitionValuesAsList(dataFile.partition(), partitionSchema);
            String pathValue = Joiner.on((String)"/").join(values);
            deleteFileLocations.add(dataFile.path().toString());
            if (checkedPartitionValues.contains(pathValue)) continue;
            try {
                Partition partition = (Partition)this.hmsClient.run(c -> c.getPartition(this.db, this.tableName, values));
                deletePartitions.put(dataFile.partition(), (Object)partition);
            }
            catch (NoSuchObjectException partition) {
            }
            catch (InterruptedException | TException e) {
                throw new RuntimeException(e);
            }
            checkedPartitionValues.add(pathValue);
        }
        if (this.validateLocation) {
            deletePartitions.values().forEach(p -> this.checkPartitionDelete(deleteFileLocations, (Partition)p));
        }
        return deletePartitions;
    }

    private void checkPartitionDelete(Set<String> deleteFiles, Partition partition) {
        String partitionLocation = partition.getSd().getLocation();
        try (AuthenticatedHadoopFileIO io = this.table.io();){
            io.listDirectory(partitionLocation).forEach(f -> {
                if (!deleteFiles.contains(f.location())) {
                    throw new CannotAlterHiveLocationException("can't delete hive partition: " + this.partitionToString(partition) + ", file under partition is not deleted: " + f.location());
                }
            });
        }
    }

    private void checkCreatePartitionDataFiles(List<DataFile> addFiles, String partitionLocation) {
        Path partitionPath = new Path(partitionLocation);
        for (DataFile df : addFiles) {
            String fileDir = TableFileUtil.getFileDir((String)df.path().toString());
            Path dirPath = new Path(fileDir);
            if (partitionPath.equals((Object)dirPath)) continue;
            throw new CannotAlterHiveLocationException("can't create new hive location: " + partitionLocation + " for data file: " + df.path().toString() + " is not under partition location path");
        }
    }

    private void checkPartitionedOrphanFilesAndDelete(boolean isUnPartitioned) {
        ArrayList partitionsToCheck = Lists.newArrayList();
        if (isUnPartitioned) {
            partitionsToCheck.add(this.unpartitionTableLocation);
        } else {
            partitionsToCheck.addAll(this.partitionToCreate.values().stream().map(partition -> partition.getSd().getLocation()).collect(Collectors.toList()));
            partitionsToCheck.addAll(this.partitionToAlterLocation.values().stream().map(partition -> partition.getSd().getLocation()).collect(Collectors.toList()));
        }
        Set addFilesPathCollect = this.addFiles.stream().map(dataFile -> dataFile.path().toString()).collect(Collectors.toSet());
        Set deleteFilesPathCollect = this.deleteFiles.stream().map(deleteFile -> deleteFile.path().toString()).collect(Collectors.toSet());
        for (String partitionLocation : partitionsToCheck) {
            AuthenticatedHadoopFileIO io = this.table.io();
            Throwable throwable = null;
            try {
                io.listPrefix(partitionLocation).forEach(f -> {
                    if (!addFilesPathCollect.contains(f.location()) && !deleteFilesPathCollect.contains(f.location())) {
                        io.deleteFile(f.location());
                        LOG.warn("Delete orphan file path: {}", (Object)f.location());
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (io == null) continue;
                if (throwable != null) {
                    try {
                        io.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                io.close();
            }
        }
    }

    private StructLikeMap<Partition> filterNewPartitionNonExists(StructLikeMap<Partition> partitionToCreate, StructLikeMap<Partition> partitionToDelete) {
        String partValue;
        StructLikeMap partitions = StructLikeMap.create((Types.StructType)this.table.spec().partitionType());
        HashMap deletePartitionValueMap = Maps.newHashMap();
        for (Partition p : partitionToDelete.values()) {
            partValue = Joiner.on((String)"/").join((Iterable)p.getValues());
            deletePartitionValueMap.put(partValue, p);
        }
        for (Map.Entry entry : partitionToCreate.entrySet()) {
            partValue = Joiner.on((String)"/").join((Iterable)((Partition)entry.getValue()).getValues());
            String location = ((Partition)entry.getValue()).getSd().getLocation();
            Partition toDelete = (Partition)deletePartitionValueMap.get(partValue);
            if (toDelete != null) {
                String deleteLocation = toDelete.getSd().getLocation();
                if (this.isPathEquals(location, deleteLocation) && this.validateLocation) {
                    throw new CannotAlterHiveLocationException("can't create new partition: " + this.partitionToString((Partition)entry.getValue()) + ", this partition will be delete and re-create with same location");
                }
                this.partitionToAlter.put((StructLike)entry.getKey(), entry.getValue());
                this.partitionToAlterLocation.put((StructLike)entry.getKey(), entry.getValue());
                partitionToDelete.remove(entry.getKey());
                continue;
            }
            try {
                Partition partitionInHive = (Partition)this.hmsClient.run(c -> c.getPartition(this.db, this.tableName, ((Partition)entry.getValue()).getValues()));
                String locationInHive = partitionInHive.getSd().getLocation();
                if (this.isPathEquals(location, locationInHive)) {
                    this.partitionToAlter.put((StructLike)entry.getKey(), entry.getValue());
                    continue;
                }
                throw new CannotAlterHiveLocationException("can't create new partition: " + this.partitionToString((Partition)entry.getValue()) + ", this partition exists in hive with different location: " + locationInHive);
            }
            catch (NoSuchObjectException e) {
                partitions.put((StructLike)entry.getKey(), entry.getValue());
            }
            catch (InterruptedException | TException e) {
                throw new RuntimeException(e);
            }
        }
        return partitions;
    }

    private void commitPartitionedTable() {
        if (!this.partitionToDelete.isEmpty()) {
            for (Partition p : this.partitionToDelete.values()) {
                try {
                    this.transactionClient.run(c -> {
                        PartitionDropOptions options = PartitionDropOptions.instance().deleteData(false).ifExists(true).purgeData(false).returnResults(false);
                        c.dropPartition(this.db, this.tableName, p.getValues(), options);
                        return 0;
                    });
                }
                catch (NoSuchObjectException e) {
                    LOG.warn("try to delete hive partition {} but partition not exist.", (Object)p);
                }
                catch (InterruptedException | TException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (!this.partitionToCreate.isEmpty()) {
            try {
                this.transactionClient.run(c -> c.addPartitions((List)Lists.newArrayList((Iterable)this.partitionToCreate.values())));
            }
            catch (InterruptedException | TException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.partitionToAlter.isEmpty()) {
            try {
                this.transactionClient.run(c -> {
                    try {
                        c.alterPartitions(this.db, this.tableName, (List)Lists.newArrayList((Iterable)this.partitionToAlter.values()), null);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                });
            }
            catch (InterruptedException | TException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void generateUnpartitionTableLocation() {
        this.unpartitionTableLocation = this.addFiles.isEmpty() ? this.createUnpartitionEmptyLocationForHive() : TableFileUtil.getFileDir((String)this.addFiles.get(0).path().toString());
    }

    private void commitNonPartitionedTable() {
        String finalLocation = this.unpartitionTableLocation;
        try {
            this.transactionClient.run(c -> {
                Table hiveTable = c.getTable(this.db, this.tableName);
                hiveTable.getSd().setLocation(finalLocation);
                HiveTableUtil.generateTableProperties(this.commitTimestamp, this.addFiles).forEach((key, value) -> hiveTable.getParameters().put(key, value));
                c.alterTable(this.db, this.tableName, hiveTable);
                return 0;
            });
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException(e);
        }
    }

    private String createUnpartitionEmptyLocationForHive() {
        String newLocation = HiveTableUtil.newHiveDataLocation(this.hiveLocation(), this.table.spec(), null, this.txId != null ? HiveTableUtil.newHiveSubdirectory(this.txId) : HiveTableUtil.newHiveSubdirectory());
        try (AuthenticatedHadoopFileIO io = this.table.io();){
            OutputFile file = io.newOutputFile(newLocation + "/.keep");
            try {
                file.createOrOverwrite().close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return newLocation;
    }

    protected void applyDeleteExpr() {
        if (this.expr == null) {
            return;
        }
        try (CloseableIterable tasks = ((TableScan)this.table.newScan().filter(this.expr)).planFiles();){
            tasks.forEach(task -> this.deleteFiles.add((DataFile)task.file()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isPathEquals(String pathA, String pathB) {
        Path path1 = new Path(pathA);
        Path path2 = new Path(pathB);
        return path1.equals((Object)path2);
    }

    private String partitionToString(Partition p) {
        return "Partition(values: [" + Joiner.on((String)"/").join((Iterable)p.getValues()) + "], location: " + p.getSd().getLocation() + ")";
    }

    protected boolean isHiveDataFile(DataFile dataFile) {
        String hiveLocation = this.hiveLocation();
        String dataFileLocation = dataFile.path().toString();
        return dataFileLocation.toLowerCase().contains(hiveLocation.toLowerCase());
    }

    public T scanManifestsWith(ExecutorService executorService) {
        this.delegate.scanManifestsWith(executorService);
        return this.self();
    }

    public T set(String property, String value) {
        if ("txId".equals(property)) {
            this.txId = Long.parseLong(value);
        }
        if (PROPERTIES_VALIDATE_LOCATION.equals(property)) {
            this.validateLocation = Boolean.parseBoolean(value);
        }
        if (DELETE_UNTRACKED_HIVE_FILE.equals(property)) {
            this.checkOrphanFiles = Boolean.parseBoolean(value);
        }
        if (SYNC_DATA_TO_HIVE.equals(property)) {
            this.syncDataToHive = Boolean.parseBoolean(value);
        }
        this.delegate.set(property, value);
        return this.self();
    }

    public T deleteWith(Consumer<String> deleteFunc) {
        this.delegate.deleteWith(deleteFunc);
        return this.self();
    }

    public T stageOnly() {
        this.delegate.stageOnly();
        return this.self();
    }

    public Snapshot apply() {
        return (Snapshot)this.delegate.apply();
    }

    public Object updateEvent() {
        return this.delegate.updateEvent();
    }

    protected abstract T self();
}

