/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.runtime.asyncprocessing.EpochManager;
import org.apache.flink.runtime.asyncprocessing.ReferenceCounted;

public class RecordContext<K>
extends ReferenceCounted<DisposerRunner> {
    static final Object EMPTY_RECORD = new Object();
    private final Object record;
    private final K key;
    private volatile boolean keyOccupied;
    private final Consumer<RecordContext<K>> disposer;
    private final int keyGroup;
    @Nullable
    private volatile Object extra;
    private final EpochManager.Epoch epoch;

    public RecordContext(Object record, K key, Consumer<RecordContext<K>> disposer, int keyGroup, EpochManager.Epoch epoch) {
        super(0);
        this.record = record;
        this.key = key;
        this.keyOccupied = false;
        this.disposer = disposer;
        this.keyGroup = keyGroup;
        this.epoch = epoch;
    }

    public Object getRecord() {
        return this.record;
    }

    public K getKey() {
        return this.key;
    }

    boolean isKeyOccupied() {
        return this.keyOccupied;
    }

    void setKeyOccupied() {
        this.keyOccupied = true;
    }

    @Override
    protected void referenceCountReachedZero(@Nullable DisposerRunner disposerRunner) {
        if (this.keyOccupied) {
            this.keyOccupied = false;
            if (disposerRunner != null) {
                disposerRunner.runDisposer(() -> this.disposer.accept(this));
            } else {
                this.disposer.accept(this);
            }
        }
    }

    public int getKeyGroup() {
        return this.keyGroup;
    }

    public void setExtra(Object extra) {
        this.extra = extra;
    }

    public Object getExtra() {
        return this.extra;
    }

    public EpochManager.Epoch getEpoch() {
        return this.epoch;
    }

    public int hashCode() {
        return Objects.hash(this.record, this.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordContext that = (RecordContext)o;
        if (!Objects.equals(this.record, that.record)) {
            return false;
        }
        if (!Objects.equals(this.keyGroup, that.keyGroup)) {
            return false;
        }
        if (!Objects.equals(this.epoch, that.epoch)) {
            return false;
        }
        return Objects.equals(this.key, that.key);
    }

    public String toString() {
        return "RecordContext{record=" + this.record + ", key=" + this.key + ", occupied=" + this.keyOccupied + ", ref=" + this.getReferenceCount() + ", epoch=" + this.epoch.id + "}";
    }

    public static interface DisposerRunner {
        public void runDisposer(Runnable var1);
    }
}

