/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.util.CollectionUtil;

final class SpillChannelManager
implements AutoCloseable {
    private final HashSet<FileIOChannel> openChannels;
    private final HashSet<FileIOChannel.ID> channelsToDeleteAtShutdown = CollectionUtil.newHashSetWithExpectedSize((int)64);
    private volatile boolean closed;

    public SpillChannelManager() {
        this.openChannels = CollectionUtil.newHashSetWithExpectedSize((int)64);
    }

    synchronized void registerChannelToBeRemovedAtShutdown(FileIOChannel.ID channel) {
        this.channelsToDeleteAtShutdown.add(channel);
    }

    synchronized void unregisterChannelToBeRemovedAtShutdown(FileIOChannel.ID channel) {
        this.channelsToDeleteAtShutdown.remove(channel);
    }

    synchronized void registerOpenChannelToBeRemovedAtShutdown(FileIOChannel channel) {
        this.openChannels.add(channel);
    }

    synchronized void unregisterOpenChannelToBeRemovedAtShutdown(FileIOChannel channel) {
        this.openChannels.remove(channel);
    }

    @Override
    public synchronized void close() {
        Object channel2;
        if (this.closed) {
            return;
        }
        this.closed = true;
        Iterator<Object> channels = this.openChannels.iterator();
        while (channels.hasNext()) {
            try {
                channel2 = channels.next();
                channels.remove();
                channel2.closeAndDelete();
            }
            catch (Throwable channel2) {}
        }
        channels = this.channelsToDeleteAtShutdown.iterator();
        while (channels.hasNext()) {
            try {
                channel2 = (FileIOChannel.ID)channels.next();
                channels.remove();
                File f = new File(((FileIOChannel.ID)channel2).getPath());
                if (!f.exists()) continue;
                f.delete();
            }
            catch (Throwable throwable) {}
        }
    }
}

