/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorUtils.class);

    public static List<Runnable> gracefulShutdown(long timeout, TimeUnit unit, ExecutorService ... executorServices) {
        for (ExecutorService executorService : executorServices) {
            executorService.shutdown();
        }
        boolean wasInterrupted = false;
        long endTime = unit.toMillis(timeout) + System.currentTimeMillis();
        long timeLeft = unit.toMillis(timeout);
        boolean hasTimeLeft = timeLeft > 0L;
        ArrayList<Runnable> outstandingTasks = new ArrayList<Runnable>();
        for (ExecutorService executorService : executorServices) {
            if (wasInterrupted || !hasTimeLeft) {
                outstandingTasks.addAll(executorService.shutdownNow());
                continue;
            }
            try {
                if (!executorService.awaitTermination(timeLeft, TimeUnit.MILLISECONDS)) {
                    LOG.warn("ExecutorService did not terminate in time. Shutting it down now.");
                    outstandingTasks.addAll(executorService.shutdownNow());
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while shutting down executor services. Shutting all remaining ExecutorServices down now.", (Throwable)e);
                outstandingTasks.addAll(executorService.shutdownNow());
                wasInterrupted = true;
                Thread.currentThread().interrupt();
            }
            timeLeft = endTime - System.currentTimeMillis();
            hasTimeLeft = timeLeft > 0L;
        }
        return outstandingTasks;
    }

    public static CompletableFuture<Void> nonBlockingShutdown(long timeout, TimeUnit unit, ExecutorService ... executorServices) {
        return CompletableFuture.supplyAsync(() -> {
            ExecutorUtils.gracefulShutdown(timeout, unit, executorServices);
            return null;
        });
    }
}

