/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizing.scan;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.amoro.data.DataFileType;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.data.DefaultKeyedFile;
import org.apache.amoro.data.FileNameRules;
import org.apache.amoro.optimizing.scan.TableFileScanHelper;
import org.apache.amoro.scan.ChangeTableIncrementalScan;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.BaseTable;
import org.apache.amoro.table.ChangeTable;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.table.KeyedTableSnapshot;
import org.apache.amoro.utils.CompatiblePropertyUtil;
import org.apache.amoro.utils.MixedTableUtil;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.StructLikeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyedTableFileScanHelper
implements TableFileScanHelper {
    private static final Logger LOG = LoggerFactory.getLogger(KeyedTableFileScanHelper.class);
    private final KeyedTable keyedTable;
    private final long changeSnapshotId;
    private final long baseSnapshotId;
    private Expression partitionFilter = Expressions.alwaysTrue();
    private final PartitionSpec spec;

    public KeyedTableFileScanHelper(KeyedTable keyedTable, KeyedTableSnapshot snapshot) {
        this.keyedTable = keyedTable;
        this.baseSnapshotId = snapshot.baseSnapshotId();
        this.changeSnapshotId = snapshot.changeSnapshotId();
        this.spec = keyedTable.spec();
    }

    @VisibleForTesting
    public static long getMaxSequenceKeepingTxIdInOrder(List<SnapshotFileGroup> snapshotFileGroups, long maxFileCntLimit) {
        if (maxFileCntLimit <= 0L || snapshotFileGroups == null || snapshotFileGroups.isEmpty()) {
            return Long.MIN_VALUE;
        }
        Collections.sort(snapshotFileGroups);
        int index = -1;
        int fileCnt = 0;
        int i = 0;
        while (i < snapshotFileGroups.size() && (long)(fileCnt += snapshotFileGroups.get(i).getFileCnt()) <= maxFileCntLimit) {
            index = i++;
        }
        if ((long)fileCnt <= maxFileCntLimit) {
            return Long.MAX_VALUE;
        }
        if (index == -1) {
            return Long.MIN_VALUE;
        }
        List<SnapshotFileGroupWrapper> snapshotFileGroupWrappers = KeyedTableFileScanHelper.wrapMinMaxTransactionId(snapshotFileGroups);
        do {
            SnapshotFileGroupWrapper current;
            if (Math.max((current = snapshotFileGroupWrappers.get(index)).getFileGroup().getTransactionId(), current.getMaxTransactionIdBefore()) >= current.getMinTransactionIdAfter()) continue;
            return current.getFileGroup().getSequence();
        } while (--index != -1);
        return Long.MIN_VALUE;
    }

    private static List<SnapshotFileGroupWrapper> wrapMinMaxTransactionId(List<SnapshotFileGroup> snapshotFileGroups) {
        ArrayList<SnapshotFileGroupWrapper> wrappedList = new ArrayList<SnapshotFileGroupWrapper>();
        for (SnapshotFileGroup snapshotFileGroup : snapshotFileGroups) {
            wrappedList.add(new SnapshotFileGroupWrapper(snapshotFileGroup));
        }
        long maxValue = Long.MIN_VALUE;
        for (SnapshotFileGroupWrapper wrapper : wrappedList) {
            wrapper.setMaxTransactionIdBefore(maxValue);
            if (wrapper.getFileGroup().getTransactionId() <= maxValue) continue;
            maxValue = wrapper.getFileGroup().getTransactionId();
        }
        long minValue = Long.MAX_VALUE;
        for (int i = wrappedList.size() - 1; i >= 0; --i) {
            SnapshotFileGroupWrapper wrapper = (SnapshotFileGroupWrapper)wrappedList.get(i);
            wrapper.setMinTransactionIdAfter(minValue);
            if (wrapper.getFileGroup().getTransactionId() >= minValue) continue;
            minValue = wrapper.getFileGroup().getTransactionId();
        }
        return wrappedList;
    }

    @Override
    public CloseableIterable<TableFileScanHelper.FileScanResult> scan() {
        StructLikeMap<Long> optimizedSequence;
        long maxSequence;
        CloseableIterable changeScanResult = CloseableIterable.empty();
        ChangeFiles changeFiles = new ChangeFiles(this.keyedTable);
        BaseTable baseTable = this.keyedTable.baseTable();
        ChangeTable changeTable = this.keyedTable.changeTable();
        if (this.changeSnapshotId != -1L && (maxSequence = this.getMaxSequenceLimit(this.keyedTable, this.changeSnapshotId, optimizedSequence = this.baseSnapshotId == -1L ? StructLikeMap.create((Types.StructType)this.keyedTable.spec().partitionType()) : MixedTableUtil.readOptimizedSequence(this.keyedTable, this.baseSnapshotId))) != Long.MIN_VALUE) {
            ChangeTableIncrementalScan changeTableIncrementalScan = changeTable.newScan().filter(this.partitionFilter).fromSequence(optimizedSequence).toSequence(maxSequence).useSnapshot(this.changeSnapshotId);
            try (CloseableIterable fileScanTasks = changeTableIncrementalScan.planFiles();){
                for (FileScanTask fileScanTask2 : fileScanTasks) {
                    changeFiles.addFile(this.wrapChangeFile((DataFile)fileScanTask2.file()));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            PartitionSpec partitionSpec = changeTable.spec();
            changeScanResult = CloseableIterable.withNoopClose((Iterable)changeFiles.allInsertFiles().map(insertFile -> {
                List<ContentFile<?>> relatedDeleteFiles = changeFiles.getRelatedDeleteFiles((DataFile)insertFile);
                return new TableFileScanHelper.FileScanResult((DataFile)insertFile, relatedDeleteFiles);
            }).collect(Collectors.toList()));
        }
        CloseableIterable baseScanResult = CloseableIterable.empty();
        if (this.baseSnapshotId != -1L) {
            baseScanResult = CloseableIterable.transform((CloseableIterable)((TableScan)baseTable.newScan().filter(this.partitionFilter)).useSnapshot(this.baseSnapshotId).planFiles(), fileScanTask -> {
                DataFile dataFile = this.wrapBaseFile((DataFile)fileScanTask.file());
                ArrayList deleteFiles = new ArrayList(fileScanTask.deletes());
                List<ContentFile<?>> relatedChangeDeleteFiles = changeFiles.getRelatedDeleteFiles(dataFile);
                deleteFiles.addAll(relatedChangeDeleteFiles);
                return new TableFileScanHelper.FileScanResult(dataFile, deleteFiles);
            });
        }
        return CloseableIterable.concat((Iterable)Lists.newArrayList((Object[])new CloseableIterable[]{changeScanResult, baseScanResult}));
    }

    @Override
    public KeyedTableFileScanHelper withPartitionFilter(Expression partitionFilter) {
        this.partitionFilter = partitionFilter;
        return this;
    }

    private DataFile wrapChangeFile(DataFile dataFile) {
        return DefaultKeyedFile.parseChange(dataFile);
    }

    private DataFile wrapBaseFile(DataFile dataFile) {
        return DefaultKeyedFile.parseBase(dataFile);
    }

    private long getMaxSequenceLimit(KeyedTable keyedTable, long changeSnapshotId, StructLikeMap<Long> partitionOptimizedSequence) {
        int maxFileCntLimit;
        ChangeTable changeTable = keyedTable.changeTable();
        Snapshot changeSnapshot = changeTable.snapshot(changeSnapshotId);
        int totalFilesInSummary = PropertyUtil.propertyAsInt((Map)changeSnapshot.summary(), (String)"total-data-files", (int)0);
        if (totalFilesInSummary <= (maxFileCntLimit = CompatiblePropertyUtil.propertyAsInt(keyedTable.properties(), "self-optimizing.max-file-count", 10000))) {
            return Long.MAX_VALUE;
        }
        ChangeTableIncrementalScan changeTableIncrementalScan = changeTable.newScan().filter(this.partitionFilter).fromSequence(partitionOptimizedSequence).useSnapshot(changeSnapshot.snapshotId());
        HashMap<Long, SnapshotFileGroup> changeFilesGroupBySequence = new HashMap<Long, SnapshotFileGroup>();
        try (CloseableIterable tasks = changeTableIncrementalScan.planFiles();){
            for (FileScanTask task : tasks) {
                SnapshotFileGroup fileGroup = changeFilesGroupBySequence.computeIfAbsent(((DataFile)task.file()).dataSequenceNumber(), key -> {
                    long txId = FileNameRules.parseChangeTransactionId(((DataFile)task.file()).path().toString(), ((DataFile)task.file()).dataSequenceNumber());
                    return new SnapshotFileGroup(((DataFile)task.file()).dataSequenceNumber(), txId);
                });
                fileGroup.addFile();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close table scan of " + keyedTable.name(), e);
        }
        if (changeFilesGroupBySequence.isEmpty()) {
            LOG.debug("{} get no change files to optimize with partitionOptimizedSequence {}", (Object)keyedTable.name(), partitionOptimizedSequence);
            return Long.MIN_VALUE;
        }
        long maxSequence = KeyedTableFileScanHelper.getMaxSequenceKeepingTxIdInOrder(new ArrayList<SnapshotFileGroup>(changeFilesGroupBySequence.values()), maxFileCntLimit);
        if (maxSequence == Long.MIN_VALUE) {
            LOG.warn("{} get no change files with self-optimizing.max-file-count={}, change it to a bigger value", (Object)keyedTable.name(), (Object)maxFileCntLimit);
        } else if (maxSequence != Long.MAX_VALUE) {
            LOG.warn("{} not all change files optimized with self-optimizing.max-file-count={}, maxSequence={}", new Object[]{keyedTable.name(), maxFileCntLimit, maxSequence});
        }
        return maxSequence;
    }

    @Override
    public PartitionSpec getSpec(int specId) {
        if (specId != this.spec.specId()) {
            throw new IllegalArgumentException("Partition spec id " + specId + " not found in table " + this.keyedTable.name());
        }
        return this.spec;
    }

    private static class SnapshotFileGroupWrapper {
        private final SnapshotFileGroup fileGroup;
        private long maxTransactionIdBefore;
        private long minTransactionIdAfter;

        public SnapshotFileGroupWrapper(SnapshotFileGroup fileGroup) {
            this.fileGroup = fileGroup;
        }

        public SnapshotFileGroup getFileGroup() {
            return this.fileGroup;
        }

        public long getMaxTransactionIdBefore() {
            return this.maxTransactionIdBefore;
        }

        public void setMaxTransactionIdBefore(long maxTransactionIdBefore) {
            this.maxTransactionIdBefore = maxTransactionIdBefore;
        }

        public long getMinTransactionIdAfter() {
            return this.minTransactionIdAfter;
        }

        public void setMinTransactionIdAfter(long minTransactionIdAfter) {
            this.minTransactionIdAfter = minTransactionIdAfter;
        }
    }

    public static class SnapshotFileGroup
    implements Comparable<SnapshotFileGroup> {
        private final long sequence;
        private final long transactionId;
        private int fileCnt = 0;

        public SnapshotFileGroup(long sequence, long transactionId) {
            this.sequence = sequence;
            this.transactionId = transactionId;
        }

        public SnapshotFileGroup(long sequence, long transactionId, int fileCnt) {
            this.sequence = sequence;
            this.transactionId = transactionId;
            this.fileCnt = fileCnt;
        }

        public void addFile() {
            ++this.fileCnt;
        }

        public long getTransactionId() {
            return this.transactionId;
        }

        public int getFileCnt() {
            return this.fileCnt;
        }

        public long getSequence() {
            return this.sequence;
        }

        @Override
        public int compareTo(SnapshotFileGroup o) {
            return Long.compare(this.sequence, o.sequence);
        }
    }

    private static class ChangeFiles {
        private final KeyedTable keyedTable;
        private final Map<String, Map<DataTreeNode, List<ContentFile<?>>>> cachedRelatedDeleteFiles = Maps.newHashMap();
        private final Map<String, Map<DataTreeNode, Set<ContentFile<?>>>> equalityDeleteFiles = Maps.newHashMap();
        private final Map<String, Map<DataTreeNode, Set<DataFile>>> insertFiles = Maps.newHashMap();

        public ChangeFiles(KeyedTable keyedTable) {
            this.keyedTable = keyedTable;
        }

        public void addFile(DataFile file) {
            String partition = this.keyedTable.spec().partitionToPath(file.partition());
            DataTreeNode node = FileNameRules.parseFileNodeFromFileName(file.path().toString());
            DataFileType type = FileNameRules.parseFileTypeForChange(file.path().toString());
            switch (type) {
                case EQ_DELETE_FILE: {
                    this.equalityDeleteFiles.computeIfAbsent(partition, key -> Maps.newHashMap()).computeIfAbsent(node, key -> Sets.newHashSet()).add(file);
                    break;
                }
                case INSERT_FILE: {
                    this.insertFiles.computeIfAbsent(partition, key -> Maps.newHashMap()).computeIfAbsent(node, key -> Sets.newHashSet()).add(file);
                    break;
                }
                default: {
                    throw new IllegalStateException("illegal file type in change store " + (Object)((Object)type));
                }
            }
        }

        public Stream<DataFile> allInsertFiles() {
            return this.insertFiles.values().stream().flatMap(dataTreeNodeSetMap -> dataTreeNodeSetMap.values().stream()).flatMap(Collection::stream);
        }

        public List<ContentFile<?>> getRelatedDeleteFiles(DataFile file) {
            String partition = this.keyedTable.spec().partitionToPath(file.partition());
            if (!this.equalityDeleteFiles.containsKey(partition)) {
                return Collections.emptyList();
            }
            DataTreeNode node = FileNameRules.parseFileNodeFromFileName(file.path().toString());
            Map partitionDeleteFiles = this.cachedRelatedDeleteFiles.computeIfAbsent(partition, key -> Maps.newHashMap());
            if (partitionDeleteFiles.containsKey(node)) {
                return (List)partitionDeleteFiles.get(node);
            }
            ArrayList result = Lists.newArrayList();
            for (Map.Entry<DataTreeNode, Set<ContentFile<?>>> entry : this.equalityDeleteFiles.get(partition).entrySet()) {
                DataTreeNode deleteNode = entry.getKey();
                if (!node.isSonOf(deleteNode) && !deleteNode.isSonOf(node)) continue;
                result.addAll((Collection)entry.getValue());
            }
            partitionDeleteFiles.put(node, result);
            return result;
        }
    }
}

