/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.Serializable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.AggregatingStateDeclaration;
import org.apache.flink.api.common.state.BroadcastStateDeclaration;
import org.apache.flink.api.common.state.ListStateDeclaration;
import org.apache.flink.api.common.state.MapStateDeclaration;
import org.apache.flink.api.common.state.ReducingStateDeclaration;
import org.apache.flink.api.common.state.StateDeclaration;
import org.apache.flink.api.common.state.ValueStateDeclaration;
import org.apache.flink.api.common.typeinfo.TypeDescriptor;

@Experimental
public class StateDeclarations {
    public static <IN, OUT, ACC> AggregatingStateDeclarationBuilder<IN, OUT, ACC> aggregatingStateBuilder(String name, TypeDescriptor<ACC> aggTypeDescriptor, AggregateFunction<IN, ACC, OUT> aggregateFunction) {
        return new AggregatingStateDeclarationBuilder<IN, OUT, ACC>(name, aggTypeDescriptor, aggregateFunction);
    }

    public static <T> ReducingStateDeclarationBuilder<T> reducingStateBuilder(String name, TypeDescriptor<T> typeInformation, ReduceFunction<T> reduceFunction) {
        return new ReducingStateDeclarationBuilder<T>(name, typeInformation, reduceFunction);
    }

    public static <K, V> MapStateDeclarationBuilder<K, V> mapStateBuilder(String name, TypeDescriptor<K> keyTypeInformation, TypeDescriptor<V> valueTypeInformation) {
        return new MapStateDeclarationBuilder<K, V>(name, keyTypeInformation, valueTypeInformation);
    }

    public static <T> ListStateDeclarationBuilder<T> listStateBuilder(String name, TypeDescriptor<T> elementTypeInformation) {
        return new ListStateDeclarationBuilder<T>(name, elementTypeInformation);
    }

    public <T> ValueStateDeclarationBuilder<T> valueStateBuilder(String name, TypeDescriptor<T> valueType) {
        return new ValueStateDeclarationBuilder<T>(name, valueType);
    }

    public static <IN, ACC, OUT> AggregatingStateDeclaration<IN, ACC, OUT> aggregatingState(String name, TypeDescriptor<ACC> aggTypeDescriptor, AggregateFunction<IN, ACC, OUT> aggregateFunction) {
        return new AggregatingStateDeclarationBuilder<IN, OUT, ACC>(name, aggTypeDescriptor, aggregateFunction).build();
    }

    public static <T> ReducingStateDeclaration<T> reducingState(String name, TypeDescriptor<T> typeInformation, ReduceFunction<T> reduceFunction) {
        return new ReducingStateDeclarationBuilder<T>(name, typeInformation, reduceFunction).build();
    }

    public static <K, V> MapStateDeclaration<K, V> mapState(String name, TypeDescriptor<K> keyTypeInformation, TypeDescriptor<V> valueTypeInformation) {
        return new MapStateDeclarationBuilder<K, V>(name, keyTypeInformation, valueTypeInformation).build();
    }

    public static <T> ListStateDeclaration<T> listState(String name, TypeDescriptor<T> elementTypeInformation) {
        return new ListStateDeclarationBuilder<T>(name, elementTypeInformation).build();
    }

    public static <T> ValueStateDeclaration<T> valueState(String name, TypeDescriptor<T> valueType) {
        return new ValueStateDeclarationBuilder<T>(name, valueType).build();
    }

    @Experimental
    public static class ValueStateDeclarationBuilder<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final TypeDescriptor<T> valueType;

        public ValueStateDeclarationBuilder(String name, TypeDescriptor<T> valueType) {
            this.name = name;
            this.valueType = valueType;
        }

        ValueStateDeclaration<T> build() {
            return new ValueStateDeclaration<T>(){

                @Override
                public TypeDescriptor<T> getTypeDescriptor() {
                    return valueType;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public StateDeclaration.RedistributionMode getRedistributionMode() {
                    return StateDeclaration.RedistributionMode.NONE;
                }
            };
        }
    }

    @Experimental
    public static class ListStateDeclarationBuilder<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final TypeDescriptor<T> elementTypeInformation;
        private ListStateDeclaration.RedistributionStrategy redistributionStrategy = ListStateDeclaration.RedistributionStrategy.SPLIT;
        private StateDeclaration.RedistributionMode redistributionMode = StateDeclaration.RedistributionMode.NONE;

        public ListStateDeclarationBuilder(String name, TypeDescriptor<T> elementTypeInformation) {
            this.name = name;
            this.elementTypeInformation = elementTypeInformation;
        }

        public ListStateDeclarationBuilder<T> redistributeBy(ListStateDeclaration.RedistributionStrategy strategy) {
            this.redistributionStrategy = strategy;
            this.redistributionMode = StateDeclaration.RedistributionMode.REDISTRIBUTABLE;
            return this;
        }

        public ListStateDeclarationBuilder<T> redistributeWithMode(StateDeclaration.RedistributionMode mode) {
            this.redistributionMode = mode;
            return this;
        }

        public ListStateDeclaration<T> build() {
            return new ListStateDeclaration<T>(){

                @Override
                public ListStateDeclaration.RedistributionStrategy getRedistributionStrategy() {
                    return redistributionStrategy;
                }

                @Override
                public TypeDescriptor<T> getTypeDescriptor() {
                    return elementTypeInformation;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public StateDeclaration.RedistributionMode getRedistributionMode() {
                    return redistributionMode;
                }
            };
        }
    }

    @Experimental
    public static class MapStateDeclarationBuilder<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final TypeDescriptor<K> keyTypeInformation;
        private final TypeDescriptor<V> valueTypeInformation;
        private final StateDeclaration.RedistributionMode redistributionMode;

        public MapStateDeclarationBuilder(String name, TypeDescriptor<K> keyTypeInformation, TypeDescriptor<V> valueTypeInformation) {
            this(name, keyTypeInformation, valueTypeInformation, StateDeclaration.RedistributionMode.NONE);
        }

        public MapStateDeclarationBuilder(String name, TypeDescriptor<K> keyTypeInformation, TypeDescriptor<V> valueTypeInformation, StateDeclaration.RedistributionMode redistributionMode) {
            this.name = name;
            this.keyTypeInformation = keyTypeInformation;
            this.valueTypeInformation = valueTypeInformation;
            this.redistributionMode = redistributionMode;
        }

        public BroadcastStateDeclaration<K, V> buildBroadcast() {
            return new BroadcastStateDeclaration<K, V>(){

                @Override
                public TypeDescriptor<K> getKeyTypeDescriptor() {
                    return keyTypeInformation;
                }

                @Override
                public TypeDescriptor<V> getValueTypeDescriptor() {
                    return valueTypeInformation;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public StateDeclaration.RedistributionMode getRedistributionMode() {
                    return StateDeclaration.RedistributionMode.IDENTICAL;
                }
            };
        }

        MapStateDeclaration<K, V> build() {
            return new MapStateDeclaration<K, V>(){

                @Override
                public TypeDescriptor<K> getKeyTypeDescriptor() {
                    return keyTypeInformation;
                }

                @Override
                public TypeDescriptor<V> getValueTypeDescriptor() {
                    return valueTypeInformation;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public StateDeclaration.RedistributionMode getRedistributionMode() {
                    return redistributionMode;
                }
            };
        }
    }

    @Experimental
    public static class AggregatingStateDeclarationBuilder<IN, OUT, ACC>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final TypeDescriptor<ACC> stateTypeDescriptor;
        private final AggregateFunction<IN, ACC, OUT> aggregateFunction;

        public AggregatingStateDeclarationBuilder(String name, TypeDescriptor<ACC> stateTypeDescriptor, AggregateFunction<IN, ACC, OUT> aggregateFunction) {
            this.name = name;
            this.stateTypeDescriptor = stateTypeDescriptor;
            this.aggregateFunction = aggregateFunction;
        }

        AggregatingStateDeclaration<IN, ACC, OUT> build() {
            return new AggregatingStateDeclaration<IN, ACC, OUT>(){

                @Override
                public TypeDescriptor<ACC> getTypeDescriptor() {
                    return stateTypeDescriptor;
                }

                @Override
                public AggregateFunction<IN, ACC, OUT> getAggregateFunction() {
                    return aggregateFunction;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public StateDeclaration.RedistributionMode getRedistributionMode() {
                    return StateDeclaration.RedistributionMode.NONE;
                }
            };
        }
    }

    @Experimental
    public static class ReducingStateDeclarationBuilder<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final TypeDescriptor<T> typeInformation;
        private final ReduceFunction<T> reduceFunction;

        public ReducingStateDeclarationBuilder(String name, TypeDescriptor<T> typeInformation, ReduceFunction<T> reduceFunction) {
            this.name = name;
            this.typeInformation = typeInformation;
            this.reduceFunction = reduceFunction;
        }

        ReducingStateDeclaration<T> build() {
            return new ReducingStateDeclaration<T>(){

                @Override
                public TypeDescriptor<T> getTypeDescriptor() {
                    return typeInformation;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public ReduceFunction<T> getReduceFunction() {
                    return reduceFunction;
                }

                @Override
                public StateDeclaration.RedistributionMode getRedistributionMode() {
                    return StateDeclaration.RedistributionMode.NONE;
                }
            };
        }
    }
}

