/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.UpdateSet;
import net.sf.jsqlparser.statement.upsert.Upsert;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import net.sf.jsqlparser.util.validation.validator.SelectValidator;

public class UpsertValidator
extends AbstractValidator<Upsert> {
    @Override
    public void validate(Upsert upsert) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.upsert);
        }
        this.validateOptionalFromItem(upsert.getTable());
        this.validateOptionalExpressions(upsert.getColumns());
        this.validateOptionalExpressions(upsert.getExpressions());
        this.validateOptionalSelect(upsert.getSelect());
        this.validateDuplicate(upsert);
    }

    private void validateOptionalSelect(Select select) {
        if (select != null) {
            SelectValidator v = this.getValidator(SelectValidator.class);
            select.accept(v);
        }
    }

    private void validateDuplicate(Upsert upsert) {
        if (upsert.getDuplicateUpdateSets() != null) {
            for (UpdateSet updateSet : upsert.getDuplicateUpdateSets()) {
                this.validateOptionalExpressions(updateSet.getColumns());
                this.validateOptionalExpressions(updateSet.getValues());
            }
        }
    }
}

