/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FederatedTable
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FederatedTable> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(FederatedTable.getter(FederatedTable::identifier)).setter(FederatedTable.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<String> DATABASE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseIdentifier").getter(FederatedTable.getter(FederatedTable::databaseIdentifier)).setter(FederatedTable.setter(Builder::databaseIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseIdentifier").build()}).build();
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(FederatedTable.getter(FederatedTable::connectionName)).setter(FederatedTable.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, DATABASE_IDENTIFIER_FIELD, CONNECTION_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String identifier;
    private final String databaseIdentifier;
    private final String connectionName;

    private FederatedTable(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.databaseIdentifier = builder.databaseIdentifier;
        this.connectionName = builder.connectionName;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String databaseIdentifier() {
        return this.databaseIdentifier;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FederatedTable)) {
            return false;
        }
        FederatedTable other = (FederatedTable)obj;
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.databaseIdentifier(), other.databaseIdentifier()) && Objects.equals(this.connectionName(), other.connectionName());
    }

    public final String toString() {
        return ToString.builder((String)"FederatedTable").add("Identifier", (Object)this.identifier()).add("DatabaseIdentifier", (Object)this.databaseIdentifier()).add("ConnectionName", (Object)this.connectionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "DatabaseIdentifier": {
                return Optional.ofNullable(clazz.cast(this.databaseIdentifier()));
            }
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FederatedTable, T> g) {
        return obj -> g.apply((FederatedTable)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identifier;
        private String databaseIdentifier;
        private String connectionName;

        private BuilderImpl() {
        }

        private BuilderImpl(FederatedTable model) {
            this.identifier(model.identifier);
            this.databaseIdentifier(model.databaseIdentifier);
            this.connectionName(model.connectionName);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getDatabaseIdentifier() {
            return this.databaseIdentifier;
        }

        public final void setDatabaseIdentifier(String databaseIdentifier) {
            this.databaseIdentifier = databaseIdentifier;
        }

        @Override
        public final Builder databaseIdentifier(String databaseIdentifier) {
            this.databaseIdentifier = databaseIdentifier;
            return this;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public FederatedTable build() {
            return new FederatedTable(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FederatedTable> {
        public Builder identifier(String var1);

        public Builder databaseIdentifier(String var1);

        public Builder connectionName(String var1);
    }
}

