/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.client;

import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ClientPool<C, E extends Exception> {
    public <R> R run(Action<R, C, E> var1) throws E, InterruptedException;

    public <R> R run(Action<R, C, E> var1, boolean var2) throws E, InterruptedException;

    public static abstract class ClientPoolImpl<C, E extends Exception>
    implements Closeable,
    ClientPool<C, E> {
        private static final Logger LOG = LoggerFactory.getLogger(ClientPoolImpl.class);
        private final int poolSize;
        private final Deque<C> clients;
        private final Class<? extends E> reconnectExc;
        private final Object signal = new Object();
        private final boolean retryByDefault;
        private volatile int currentSize;
        private boolean closed;

        public ClientPoolImpl(int poolSize, Class<? extends E> reconnectExc, boolean retryByDefault) {
            this.poolSize = poolSize;
            this.reconnectExc = reconnectExc;
            this.clients = new ArrayDeque<C>(poolSize);
            this.currentSize = 0;
            this.closed = false;
            this.retryByDefault = retryByDefault;
        }

        @Override
        public <R> R run(Action<R, C, E> action) throws E, InterruptedException {
            return this.run(action, this.retryByDefault);
        }

        @Override
        public <R> R run(Action<R, C, E> action, boolean retry) throws E, InterruptedException {
            C client = this.get();
            try {
                R r = action.run(client);
                return r;
            }
            catch (Exception exc) {
                if (retry && this.isConnectionException(exc)) {
                    try {
                        client = this.reconnect(client);
                    }
                    catch (Exception ignored) {
                        throw (Exception)this.reconnectExc.cast(exc);
                    }
                    R r = action.run(client);
                    return r;
                }
                throw exc;
            }
            finally {
                this.release(client);
            }
        }

        protected abstract C newClient();

        protected abstract C reconnect(C var1);

        protected boolean isConnectionException(Exception exc) {
            return this.reconnectExc.isInstance(exc);
        }

        protected abstract void close(C var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void close() {
            this.closed = true;
            try {
                while (this.currentSize > 0) {
                    Object object;
                    if (!this.clients.isEmpty()) {
                        object = this;
                        synchronized (object) {
                            if (!this.clients.isEmpty()) {
                                C client = this.clients.removeFirst();
                                this.close(client);
                                --this.currentSize;
                            }
                        }
                    }
                    if (!this.clients.isEmpty() || this.currentSize <= 0) continue;
                    object = this.signal;
                    synchronized (object) {
                        this.signal.wait(1000L);
                    }
                }
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.warn("Interrupted while shutting down pool. Some clients may not be closed.", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private C get() throws InterruptedException {
            Preconditions.checkState(!this.closed, "Cannot get a client from a closed pool");
            while (true) {
                Object object;
                if (!this.clients.isEmpty() || this.currentSize < this.poolSize) {
                    object = this;
                    synchronized (object) {
                        if (!this.clients.isEmpty()) {
                            return this.clients.removeFirst();
                        }
                        if (this.currentSize < this.poolSize) {
                            C client = this.newClient();
                            ++this.currentSize;
                            return client;
                        }
                    }
                }
                object = this.signal;
                synchronized (object) {
                    this.signal.wait(1000L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void release(C client) {
            Object object = this;
            synchronized (object) {
                this.clients.addFirst(client);
            }
            object = this.signal;
            synchronized (object) {
                this.signal.notify();
            }
        }

        public int poolSize() {
            return this.poolSize;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }

    public static interface Action<R, C, E extends Exception> {
        public R run(C var1) throws E;
    }
}

