/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.options.description.DescribedEnum;
import org.apache.paimon.options.description.InlineElement;
import org.apache.paimon.options.description.TextElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtils.class);
    public static final ConfigOption<HadoopConfigLoader> HADOOP_CONF_LOADER = ConfigOptions.key("hadoop-conf-loader").enumType(HadoopConfigLoader.class).defaultValue(HadoopConfigLoader.ALL).withDescription("Specifies the way of loading hadoop config.");
    private static final String[] CONFIG_PREFIXES = new String[]{"hadoop."};
    public static final String HADOOP_HOME_ENV = "HADOOP_HOME";
    public static final String HADOOP_CONF_ENV = "HADOOP_CONF_DIR";
    public static final String PATH_HADOOP_CONFIG = "hadoop-conf-dir";

    public static Configuration getHadoopConfiguration(Options options) {
        String hadoopConfDir;
        HdfsConfiguration result = new HdfsConfiguration();
        boolean foundHadoopConfiguration = false;
        String[] possibleHadoopConfPaths = new String[2];
        HadoopConfigLoader loader = options.get(HADOOP_CONF_LOADER);
        String hadoopHomeDir = System.getenv(HADOOP_HOME_ENV);
        if (hadoopHomeDir != null && loader.loadEnv()) {
            LOG.debug("Searching Hadoop configuration files in HADOOP_HOME: {}", (Object)hadoopHomeDir);
            possibleHadoopConfPaths[0] = hadoopHomeDir + "/conf";
            possibleHadoopConfPaths[1] = hadoopHomeDir + "/etc/hadoop";
        }
        for (String possibleHadoopConfPath : possibleHadoopConfPaths) {
            if (possibleHadoopConfPath == null) continue;
            foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound((Configuration)result, possibleHadoopConfPath);
        }
        String hadoopConfigPath = options.getString(PATH_HADOOP_CONFIG, null);
        if (hadoopConfigPath != null && loader.loadOption()) {
            LOG.debug("Searching Hadoop configuration files in Paimon config: {}", (Object)hadoopConfigPath);
            boolean bl = foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound((Configuration)result, hadoopConfigPath) || foundHadoopConfiguration;
        }
        if ((hadoopConfDir = System.getenv(HADOOP_CONF_ENV)) != null && loader.loadEnv()) {
            LOG.debug("Searching Hadoop configuration files in HADOOP_CONF_DIR: {}", (Object)hadoopConfDir);
            foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound((Configuration)result, hadoopConfDir) || foundHadoopConfiguration;
        }
        for (String key : options.keySet()) {
            for (String prefix : CONFIG_PREFIXES) {
                if (!key.startsWith(prefix)) continue;
                String newKey = key.substring(prefix.length());
                String value = options.getString(key, null);
                result.set(newKey, value);
                LOG.debug("Adding Paimon config entry for {} as {}={} to Hadoop config", new Object[]{key, newKey, value});
                foundHadoopConfiguration = true;
            }
        }
        if (!foundHadoopConfiguration) {
            LOG.warn("Could not find Hadoop configuration via any of the supported methods");
        }
        return result;
    }

    private static boolean addHadoopConfIfFound(Configuration configuration, String possibleHadoopConfPath) {
        boolean foundHadoopConfiguration = false;
        if (new File(possibleHadoopConfPath).exists()) {
            if (new File(possibleHadoopConfPath + "/core-site.xml").exists()) {
                configuration.addResource(new Path(possibleHadoopConfPath + "/core-site.xml"));
                LOG.debug("Adding " + possibleHadoopConfPath + "/core-site.xml to hadoop configuration");
                foundHadoopConfiguration = true;
            }
            if (new File(possibleHadoopConfPath + "/hdfs-site.xml").exists()) {
                configuration.addResource(new Path(possibleHadoopConfPath + "/hdfs-site.xml"));
                LOG.debug("Adding " + possibleHadoopConfPath + "/hdfs-site.xml to hadoop configuration");
                foundHadoopConfiguration = true;
            }
        }
        return foundHadoopConfiguration;
    }

    public static enum HadoopConfigLoader implements DescribedEnum
    {
        ALL("all", "Load Hadoop conf from environment variables and catalog option.", true, true),
        ENV("env", "Load Hadoop conf from environment variables only.", true, false),
        OPTION("option", "Load Hadoop conf from catalog option only.", false, true);

        private final String value;
        private final String description;
        private final boolean loadEnv;
        private final boolean loadOption;

        private HadoopConfigLoader(String value, String description, boolean loadEnv, boolean loadOption) {
            this.value = value;
            this.description = description;
            this.loadEnv = loadEnv;
            this.loadOption = loadOption;
        }

        public boolean loadEnv() {
            return this.loadEnv;
        }

        public boolean loadOption() {
            return this.loadOption;
        }

        public String toString() {
            return this.value;
        }

        @Override
        public InlineElement getDescription() {
            return TextElement.text(this.description);
        }
    }
}

