/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hadoop.authentication.kerberos;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.catalog.hadoop.authentication.kerberos.FetchFileUtils;
import org.apache.gravitino.catalog.hadoop.authentication.kerberos.KerberosConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosClient.class);
    private ScheduledThreadPoolExecutor checkTgtExecutor;
    private final Map<String, String> conf;
    private final Configuration hadoopConf;
    private final boolean refreshCredentials;

    public KerberosClient(Map<String, String> conf, Configuration hadoopConf, boolean refreshCredentials) {
        this.conf = conf;
        this.hadoopConf = hadoopConf;
        this.refreshCredentials = refreshCredentials;
    }

    public String login(String keytabFilePath) throws IOException {
        KerberosConfig kerberosConfig = new KerberosConfig(this.conf);
        String catalogPrincipal = kerberosConfig.getPrincipalName();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)catalogPrincipal), (Object)"The principal can't be blank");
        List principalComponents = Splitter.on((char)'@').splitToList((CharSequence)catalogPrincipal);
        Preconditions.checkArgument((principalComponents.size() == 2 ? 1 : 0) != 0, (Object)"The principal has the wrong format");
        UserGroupInformation.setConfiguration((Configuration)this.hadoopConf);
        UserGroupInformation.loginUserFromKeytab((String)catalogPrincipal, (String)keytabFilePath);
        UserGroupInformation kerberosLoginUgi = UserGroupInformation.getLoginUser();
        if (this.refreshCredentials) {
            this.checkTgtExecutor = new ScheduledThreadPoolExecutor(1, KerberosClient.getThreadFactory("check-tgt"));
            int checkInterval = kerberosConfig.getCheckIntervalSec();
            this.checkTgtExecutor.scheduleAtFixedRate(() -> {
                try {
                    kerberosLoginUgi.checkTGTAndReloginFromKeytab();
                }
                catch (Exception e) {
                    LOG.error("Fail to refresh ugi token: ", (Throwable)e);
                }
            }, checkInterval, checkInterval, TimeUnit.SECONDS);
        }
        return (String)principalComponents.get(1);
    }

    public File saveKeyTabFileFromUri(String keytabPath) throws IOException {
        KerberosConfig kerberosConfig = new KerberosConfig(this.conf);
        String keyTabUri = kerberosConfig.getKeytab();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)keyTabUri), (Object)"Keytab uri can't be blank");
        Preconditions.checkArgument((!keyTabUri.trim().startsWith("hdfs") ? 1 : 0) != 0, (Object)"Keytab uri doesn't support to use HDFS");
        File keytabsDir = new File("keytabs");
        if (!keytabsDir.exists()) {
            keytabsDir.mkdir();
        }
        File keytabFile = new File(keytabPath);
        keytabFile.deleteOnExit();
        if (keytabFile.exists() && !keytabFile.delete()) {
            throw new IllegalStateException(String.format("Fail to delete keytab file %s", keytabFile.getAbsolutePath()));
        }
        int fetchKeytabFileTimeout = kerberosConfig.getFetchTimeoutSec();
        FetchFileUtils.fetchFileFromUri(keyTabUri, keytabFile, fetchKeytabFileTimeout, this.hadoopConf);
        return keytabFile;
    }

    private static ThreadFactory getThreadFactory(String factoryName) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(factoryName + "-%d").build();
    }

    @Override
    public void close() throws IOException {
        if (this.checkTgtExecutor != null) {
            this.checkTgtExecutor.shutdown();
        }
    }
}

