/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.connector;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.model.ModelVersion;

@Evolving
public abstract class BaseModelVersion
implements ModelVersion {
    protected int version;
    protected String[] aliases;
    @Nullable
    protected String comment;
    protected String uri;
    protected Map<String, String> properties;
    protected AuditInfo auditInfo;

    public int version() {
        return this.version;
    }

    public String[] aliases() {
        return this.aliases;
    }

    public String comment() {
        return this.comment;
    }

    public String uri() {
        return this.uri;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    public static abstract class BaseModelVersionBuilder<SELF extends Builder<SELF, T>, T extends BaseModelVersion>
    implements Builder<SELF, T> {
        protected int version;
        protected String[] aliases;
        protected String comment;
        protected String uri;
        protected Map<String, String> properties;
        protected AuditInfo auditInfo;

        @Override
        public SELF withVersion(int version) {
            this.version = version;
            return this.self();
        }

        @Override
        public SELF withAliases(String[] aliases) {
            this.aliases = aliases;
            return this.self();
        }

        @Override
        public SELF withComment(String comment) {
            this.comment = comment;
            return this.self();
        }

        @Override
        public SELF withUri(String uri) {
            this.uri = uri;
            return this.self();
        }

        @Override
        public SELF withProperties(Map<String, String> properties) {
            this.properties = properties;
            return this.self();
        }

        @Override
        public SELF withAuditInfo(AuditInfo auditInfo) {
            this.auditInfo = auditInfo;
            return this.self();
        }

        @Override
        public T build() {
            return this.internalBuild();
        }

        protected abstract T internalBuild();

        private SELF self() {
            return (SELF)this;
        }
    }

    static interface Builder<SELF extends Builder<SELF, T>, T extends BaseModelVersion> {
        public SELF withVersion(int var1);

        public SELF withAliases(String[] var1);

        public SELF withComment(String var1);

        public SELF withUri(String var1);

        public SELF withProperties(Map<String, String> var1);

        public SELF withAuditInfo(AuditInfo var1);

        public T build();
    }
}

