/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import org.apache.gravitino.storage.relational.po.MetalakePO;
import org.apache.ibatis.annotations.Param;

public class MetalakeMetaBaseSQLProvider {
    public String listMetalakePOs() {
        return "SELECT metalake_id as metalakeId, metalake_name as metalakeName, metalake_comment as metalakeComment, properties, audit_info as auditInfo, schema_version as schemaVersion, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM metalake_meta WHERE deleted_at = 0";
    }

    public String selectMetalakeMetaByName(@Param(value="metalakeName") String metalakeName) {
        return "SELECT metalake_id as metalakeId, metalake_name as metalakeName, metalake_comment as metalakeComment, properties, audit_info as auditInfo, schema_version as schemaVersion, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM metalake_meta WHERE metalake_name = #{metalakeName} and deleted_at = 0";
    }

    public String selectMetalakeMetaById(@Param(value="metalakeId") Long metalakeId) {
        return "SELECT metalake_id as metalakeId, metalake_name as metalakeName, metalake_comment as metalakeComment, properties, audit_info as auditInfo, schema_version as schemaVersion, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM metalake_meta WHERE metalake_id = #{metalakeId} and deleted_at = 0";
    }

    public String selectMetalakeIdMetaByName(@Param(value="metalakeName") String metalakeName) {
        return "SELECT metalake_id as metalakeId FROM metalake_meta WHERE metalake_name = #{metalakeName} and deleted_at = 0";
    }

    public String insertMetalakeMeta(@Param(value="metalakeMeta") MetalakePO metalakePO) {
        return "INSERT INTO metalake_meta(metalake_id, metalake_name, metalake_comment, properties, audit_info, schema_version, current_version, last_version, deleted_at) VALUES( #{metalakeMeta.metalakeId}, #{metalakeMeta.metalakeName}, #{metalakeMeta.metalakeComment}, #{metalakeMeta.properties}, #{metalakeMeta.auditInfo}, #{metalakeMeta.schemaVersion}, #{metalakeMeta.currentVersion}, #{metalakeMeta.lastVersion}, #{metalakeMeta.deletedAt} )";
    }

    public String insertMetalakeMetaOnDuplicateKeyUpdate(@Param(value="metalakeMeta") MetalakePO metalakePO) {
        return "INSERT INTO metalake_meta(metalake_id, metalake_name, metalake_comment, properties, audit_info, schema_version, current_version, last_version, deleted_at) VALUES( #{metalakeMeta.metalakeId}, #{metalakeMeta.metalakeName}, #{metalakeMeta.metalakeComment}, #{metalakeMeta.properties}, #{metalakeMeta.auditInfo}, #{metalakeMeta.schemaVersion}, #{metalakeMeta.currentVersion}, #{metalakeMeta.lastVersion}, #{metalakeMeta.deletedAt} ) ON DUPLICATE KEY UPDATE metalake_name = #{metalakeMeta.metalakeName}, metalake_comment = #{metalakeMeta.metalakeComment}, properties = #{metalakeMeta.properties}, audit_info = #{metalakeMeta.auditInfo}, schema_version = #{metalakeMeta.schemaVersion}, current_version = #{metalakeMeta.currentVersion}, last_version = #{metalakeMeta.lastVersion}, deleted_at = #{metalakeMeta.deletedAt}";
    }

    public String updateMetalakeMeta(@Param(value="newMetalakeMeta") MetalakePO newMetalakePO, @Param(value="oldMetalakeMeta") MetalakePO oldMetalakePO) {
        return "UPDATE metalake_meta SET metalake_name = #{newMetalakeMeta.metalakeName}, metalake_comment = #{newMetalakeMeta.metalakeComment}, properties = #{newMetalakeMeta.properties}, audit_info = #{newMetalakeMeta.auditInfo}, schema_version = #{newMetalakeMeta.schemaVersion}, current_version = #{newMetalakeMeta.currentVersion}, last_version = #{newMetalakeMeta.lastVersion} WHERE metalake_id = #{oldMetalakeMeta.metalakeId} AND metalake_name = #{oldMetalakeMeta.metalakeName} AND (metalake_comment = #{oldMetalakeMeta.metalakeComment}   OR (metalake_comment IS NULL and #{oldMetalakeMeta.metalakeComment} IS NULL)) AND properties = #{oldMetalakeMeta.properties} AND audit_info = #{oldMetalakeMeta.auditInfo} AND schema_version = #{oldMetalakeMeta.schemaVersion} AND current_version = #{oldMetalakeMeta.currentVersion} AND last_version = #{oldMetalakeMeta.lastVersion} AND deleted_at = 0";
    }

    public String softDeleteMetalakeMetaByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE metalake_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    public String deleteMetalakeMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM metalake_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }
}

