/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.MetalakeDTO;
import org.apache.gravitino.dto.responses.BaseResponse;

public class MetalakeListResponse
extends BaseResponse {
    @JsonProperty(value="metalakes")
    private final MetalakeDTO[] metalakes;

    public MetalakeListResponse(MetalakeDTO[] metalakes) {
        super(0);
        this.metalakes = metalakes;
    }

    public MetalakeListResponse() {
        this.metalakes = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument((this.metalakes != null ? 1 : 0) != 0, (Object)"metalakes must be non-null");
        Arrays.stream(this.metalakes).forEach(metalake -> {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)metalake.name()), (Object)"metalake 'name' must not be null and empty");
            Preconditions.checkArgument((metalake.auditInfo() != null ? 1 : 0) != 0, (Object)"metalake 'audit' must not be null");
        });
    }

    public MetalakeDTO[] getMetalakes() {
        return this.metalakes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetalakeListResponse)) {
            return false;
        }
        MetalakeListResponse other = (MetalakeListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getMetalakes(), other.getMetalakes());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MetalakeListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getMetalakes());
        return result;
    }

    @Override
    public String toString() {
        return "MetalakeListResponse(metalakes=" + Arrays.deepToString(this.getMetalakes()) + ")";
    }
}

