/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;

@Public
public class DeletionFile {
    private final String path;
    private final long offset;
    private final long length;

    public DeletionFile(String path, long offset, long length) {
        this.path = path;
        this.offset = offset;
        this.length = length;
    }

    public String path() {
        return this.path;
    }

    public long offset() {
        return this.offset;
    }

    public long length() {
        return this.length;
    }

    public static void serialize(DataOutputView out, @Nullable DeletionFile file) throws IOException {
        if (file == null) {
            out.write(0);
        } else {
            out.write(1);
            out.writeUTF(file.path);
            out.writeLong(file.offset);
            out.writeLong(file.length);
        }
    }

    public static void serializeList(DataOutputView out, @Nullable List<DeletionFile> files) throws IOException {
        if (files == null) {
            out.write(0);
        } else {
            out.write(1);
            out.writeInt(files.size());
            for (DeletionFile file : files) {
                DeletionFile.serialize(out, file);
            }
        }
    }

    @Nullable
    public static DeletionFile deserialize(DataInputView in) throws IOException {
        if (in.readByte() == 0) {
            return null;
        }
        String path = in.readUTF();
        long offset = in.readLong();
        long length = in.readLong();
        return new DeletionFile(path, offset, length);
    }

    @Nullable
    public static List<DeletionFile> deserializeList(DataInputView in) throws IOException {
        ArrayList<DeletionFile> files = null;
        if (in.readByte() == 1) {
            int size = in.readInt();
            files = new ArrayList<DeletionFile>(size);
            for (int i = 0; i < size; ++i) {
                files.add(DeletionFile.deserialize(in));
            }
        }
        return files;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeletionFile)) {
            return false;
        }
        DeletionFile other = (DeletionFile)o;
        return Objects.equals(this.path, other.path) && this.offset == other.offset && this.length == other.length;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.offset, this.length);
    }

    public String toString() {
        return String.format("{path = %s, offset = %d, length = %d}", this.path, this.offset, this.length);
    }
}

