/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.PartitionSettedRow;
import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.casting.CastedRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.PartitionInfo;
import org.apache.paimon.data.columnar.ColumnarRowIterator;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.ProjectedRow;

public class FileRecordReader
implements RecordReader<InternalRow> {
    private final RecordReader<InternalRow> reader;
    @Nullable
    private final int[] indexMapping;
    @Nullable
    private final PartitionInfo partitionInfo;
    @Nullable
    private final CastFieldGetter[] castMapping;

    @Nullable
    public RecordReader.RecordIterator<InternalRow> readBatch() throws IOException {
        RecordReader.RecordIterator iterator = this.reader.readBatch();
        if (iterator == null) {
            return null;
        }
        if (iterator instanceof ColumnarRowIterator) {
            iterator = ((ColumnarRowIterator)iterator).mapping(this.partitionInfo, this.indexMapping);
        } else {
            if (this.partitionInfo != null) {
                PartitionSettedRow partitionSettedRow = PartitionSettedRow.from((PartitionInfo)this.partitionInfo);
                iterator = iterator.transform(arg_0 -> ((PartitionSettedRow)partitionSettedRow).replaceRow(arg_0));
            }
            if (this.indexMapping != null) {
                ProjectedRow projectedRow = ProjectedRow.from((int[])this.indexMapping);
                iterator = iterator.transform(arg_0 -> ((ProjectedRow)projectedRow).replaceRow(arg_0));
            }
        }
        if (this.castMapping != null) {
            CastedRow castedRow = CastedRow.from(this.castMapping);
            iterator = iterator.transform(castedRow::replaceRow);
        }
        return iterator;
    }

    public FileRecordReader(FormatReaderFactory readerFactory, FormatReaderFactory.Context context, @Nullable int[] indexMapping, @Nullable CastFieldGetter[] castMapping, @Nullable PartitionInfo partitionInfo) throws IOException {
        try {
            this.reader = readerFactory.createReader(context);
        }
        catch (Exception e) {
            FileUtils.checkExists(context.fileIO(), context.filePath());
            throw e;
        }
        this.indexMapping = indexMapping;
        this.partitionInfo = partitionInfo;
        this.castMapping = castMapping;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

