/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.FileEntry;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.stats.StatsFileHandler;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileDeletionBase {
    private static final Logger LOG = LoggerFactory.getLogger(FileDeletionBase.class);
    protected final FileIO fileIO;
    protected final FileStorePathFactory pathFactory;
    protected final ManifestFile manifestFile;
    protected final ManifestList manifestList;
    protected final IndexFileHandler indexFileHandler;
    protected final StatsFileHandler statsFileHandler;
    protected final Map<BinaryRow, Set<Integer>> deletionBuckets;
    protected final Executor ioExecutor;

    public FileDeletionBase(FileIO fileIO, FileStorePathFactory pathFactory, ManifestFile manifestFile, ManifestList manifestList, IndexFileHandler indexFileHandler, StatsFileHandler statsFileHandler) {
        this.fileIO = fileIO;
        this.pathFactory = pathFactory;
        this.manifestFile = manifestFile;
        this.manifestList = manifestList;
        this.indexFileHandler = indexFileHandler;
        this.statsFileHandler = statsFileHandler;
        this.deletionBuckets = new HashMap<BinaryRow, Set<Integer>>();
        this.ioExecutor = FileUtils.COMMON_IO_FORK_JOIN_POOL;
    }

    public abstract void cleanUnusedDataFiles(Snapshot var1, Predicate<ManifestEntry> var2);

    public abstract void cleanUnusedManifests(Snapshot var1, Set<String> var2);

    public void cleanDataDirectories() {
        if (this.deletionBuckets.isEmpty()) {
            return;
        }
        HashMap<Integer, Set> deduplicate = new HashMap<Integer, Set>();
        for (Map.Entry<BinaryRow, Set<Integer>> entry : this.deletionBuckets.entrySet()) {
            ArrayList<Path> toDeleteEmptyDirectory = new ArrayList<Path>();
            for (Integer bucket : entry.getValue()) {
                toDeleteEmptyDirectory.add(this.pathFactory.bucketPath(entry.getKey(), bucket));
            }
            this.deleteFiles(toDeleteEmptyDirectory, this::tryDeleteEmptyDirectory);
            List<Path> hierarchicalPaths = this.pathFactory.getHierarchicalPartitionPath(entry.getKey());
            int hierarchies = hierarchicalPaths.size();
            if (hierarchies == 0 || !this.tryDeleteEmptyDirectory(hierarchicalPaths.get(hierarchies - 1))) continue;
            for (int hierarchy = 0; hierarchy < hierarchies - 1; ++hierarchy) {
                Path path = hierarchicalPaths.get(hierarchy);
                deduplicate.computeIfAbsent(hierarchy, i -> new HashSet()).add(path);
            }
        }
        for (int hierarchy = deduplicate.size() - 1; hierarchy >= 0; --hierarchy) {
            ((Set)deduplicate.get(hierarchy)).forEach(this::tryDeleteEmptyDirectory);
        }
        this.deletionBuckets.clear();
    }

    protected void recordDeletionBuckets(ManifestEntry entry) {
        this.deletionBuckets.computeIfAbsent(entry.partition(), p -> new HashSet()).add(entry.bucket());
    }

    public void cleanUnusedStatisticsManifests(Snapshot snapshot, Set<String> skippingSet) {
        if (snapshot.statistics() != null && !skippingSet.contains(snapshot.statistics())) {
            this.statsFileHandler.deleteStats(snapshot.statistics());
        }
    }

    public void cleanUnusedIndexManifests(Snapshot snapshot, Set<String> skippingSet) {
        String indexManifest = snapshot.indexManifest();
        if (indexManifest != null && this.indexFileHandler.existsManifest(indexManifest)) {
            List<IndexManifestEntry> indexManifestEntries = this.indexFileHandler.readManifest(indexManifest);
            indexManifestEntries.removeIf(entry -> skippingSet.contains(entry.indexFile().fileName()));
            this.deleteFiles(indexManifestEntries, this.indexFileHandler::deleteIndexFile);
            if (!skippingSet.contains(indexManifest)) {
                this.indexFileHandler.deleteManifest(indexManifest);
            }
        }
    }

    public void cleanUnusedManifestList(String manifestName, Set<String> skippingSet) {
        ArrayList<String> toDeleteManifests = new ArrayList<String>();
        List<ManifestFileMeta> toExpireManifests = this.tryReadManifestList(manifestName);
        for (ManifestFileMeta manifest : toExpireManifests) {
            String fileName = manifest.fileName();
            if (skippingSet.contains(fileName)) continue;
            toDeleteManifests.add(fileName);
            skippingSet.add(fileName);
        }
        if (!skippingSet.contains(manifestName)) {
            toDeleteManifests.add(manifestName);
        }
        this.deleteFiles(toDeleteManifests, this.manifestFile::delete);
    }

    public void cleanUnusedManifests(Snapshot snapshot, Set<String> skippingSet, boolean deleteChangelog) {
        this.cleanUnusedManifestList(snapshot.baseManifestList(), skippingSet);
        this.cleanUnusedManifestList(snapshot.deltaManifestList(), skippingSet);
        if (deleteChangelog && snapshot.changelogManifestList() != null) {
            this.cleanUnusedManifestList(snapshot.changelogManifestList(), skippingSet);
        }
        this.cleanUnusedIndexManifests(snapshot, skippingSet);
        this.cleanUnusedStatisticsManifests(snapshot, skippingSet);
    }

    protected List<ManifestFileMeta> tryReadManifestList(String manifestListName) {
        try {
            return this.manifestList.read(manifestListName);
        }
        catch (Exception e) {
            LOG.warn("Failed to read manifest list file " + manifestListName, (Throwable)e);
            return Collections.emptyList();
        }
    }

    protected List<String> tryReadDataManifests(Snapshot snapshot) {
        List<ManifestFileMeta> manifestFileMetas = this.tryReadManifestList(snapshot.baseManifestList());
        manifestFileMetas.addAll(this.tryReadManifestList(snapshot.deltaManifestList()));
        return this.readManifestFileNames(manifestFileMetas);
    }

    protected List<String> readManifestFileNames(List<ManifestFileMeta> manifestFileMetas) {
        return manifestFileMetas.stream().map(ManifestFileMeta::fileName).collect(Collectors.toCollection(LinkedList::new));
    }

    protected void addMergedDataFiles(Map<BinaryRow, Map<Integer, Set<String>>> dataFiles, Snapshot snapshot) throws IOException {
        for (ManifestEntry entry : this.readMergedDataFiles(snapshot)) {
            dataFiles.computeIfAbsent(entry.partition(), p -> new HashMap()).computeIfAbsent(entry.bucket(), b -> new HashSet()).add(entry.file().fileName());
        }
    }

    protected Collection<ManifestEntry> readMergedDataFiles(Snapshot snapshot) throws IOException {
        List<String> files = this.tryReadDataManifests(snapshot);
        HashMap map = new HashMap();
        for (String manifest : files) {
            List entries = this.manifestFile.readWithIOException(manifest);
            FileEntry.mergeEntries(entries, map);
        }
        return map.values();
    }

    protected boolean containsDataFile(Map<BinaryRow, Map<Integer, Set<String>>> dataFiles, ManifestEntry testee) {
        Set<String> fileNames;
        Map<Integer, Set<String>> buckets = dataFiles.get(testee.partition());
        if (buckets != null && (fileNames = buckets.get(testee.bucket())) != null) {
            return fileNames.contains(testee.file().fileName());
        }
        return false;
    }

    public Set<String> manifestSkippingSet(Snapshot skippingSnapshot) {
        return this.manifestSkippingSet(Collections.singletonList(skippingSnapshot));
    }

    public Set<String> manifestSkippingSet(List<Snapshot> skippingSnapshots) {
        HashSet<String> skippingSet = new HashSet<String>();
        for (Snapshot skippingSnapshot : skippingSnapshots) {
            skippingSet.add(skippingSnapshot.baseManifestList());
            skippingSet.add(skippingSnapshot.deltaManifestList());
            skippingSnapshot.dataManifests(this.manifestList).stream().map(ManifestFileMeta::fileName).forEach(skippingSet::add);
            String indexManifest = skippingSnapshot.indexManifest();
            if (indexManifest != null) {
                skippingSet.add(indexManifest);
                this.indexFileHandler.readManifest(indexManifest).stream().map(IndexManifestEntry::indexFile).map(IndexFileMeta::fileName).forEach(skippingSet::add);
            }
            if (skippingSnapshot.statistics() == null) continue;
            skippingSet.add(skippingSnapshot.statistics());
        }
        return skippingSet;
    }

    private boolean tryDeleteEmptyDirectory(Path path) {
        try {
            this.fileIO.delete(path, false);
            return true;
        }
        catch (IOException e) {
            LOG.debug("Failed to delete directory '{}'. Check whether it is empty.", (Object)path);
            return false;
        }
    }

    protected <T> void deleteFiles(Collection<T> files, Consumer<T> deletion) {
        if (files.isEmpty()) {
            return;
        }
        ArrayList<CompletableFuture<Void>> deletionFutures = new ArrayList<CompletableFuture<Void>>(files.size());
        for (Object file : files) {
            deletionFutures.add(CompletableFuture.runAsync(() -> deletion.accept(file), this.ioExecutor));
        }
        try {
            CompletableFuture.allOf(deletionFutures.toArray(new CompletableFuture[0])).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

