/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.paimon.branch.TableBranch;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;

public class BranchesTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String BRANCHES = "branches";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "branch_name", (DataType)SerializationUtils.newStringType(false)), new DataField(1, "created_from_tag", (DataType)SerializationUtils.newStringType(false)), new DataField(2, "created_from_snapshot", (DataType)new BigIntType(false)), new DataField(3, "create_time", (DataType)new TimestampType(false, 3))));
    private final FileIO fileIO;
    private final Path location;

    public BranchesTable(FileIO fileIO, Path location) {
        this.fileIO = fileIO;
        this.location = location;
    }

    @Override
    public String name() {
        return this.location.getName() + "$" + BRANCHES;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Arrays.asList("branch_name", "tag_name");
    }

    @Override
    public InnerTableScan newScan() {
        return new BranchesScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new BranchesRead(this.fileIO);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new BranchesTable(this.fileIO, this.location);
    }

    private static class BranchesRead
    implements InnerTableRead {
        private final FileIO fileIO;
        private int[][] projection;

        public BranchesRead(FileIO fileIO) {
            this.fileIO = fileIO;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withProjection(int[][] projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) {
            if (!(split instanceof BranchesSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Path location = ((BranchesSplit)split).location;
            FileStoreTable table = FileStoreTableFactory.create(this.fileIO, location);
            List<TableBranch> branches = table.branchManager().branches();
            Iterator rows = Iterators.transform(branches.iterator(), this::toRow);
            if (this.projection != null) {
                rows = Iterators.transform((Iterator)rows, row -> ProjectedRow.from((int[][])this.projection).replaceRow(row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private InternalRow toRow(TableBranch branch) {
            return GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)branch.getBranchName()), BinaryString.fromString((String)branch.getCreatedFromTag()), branch.getCreatedFromSnapshot(), Timestamp.fromLocalDateTime((LocalDateTime)DateTimeUtils.toLocalDateTime((long)branch.getCreateTime()))});
        }
    }

    private static class BranchesSplit
    implements Split {
        private static final long serialVersionUID = 1L;
        private final long rowCount;
        private final Path location;

        private BranchesSplit(long rowCount, Path location) {
            this.rowCount = rowCount;
            this.location = location;
        }

        @Override
        public long rowCount() {
            return this.rowCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BranchesSplit that = (BranchesSplit)o;
            return Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private class BranchesScan
    extends ReadOnceTableScan {
        private BranchesScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            FileStoreTable table = FileStoreTableFactory.create(BranchesTable.this.fileIO, BranchesTable.this.location);
            long rowCount = table.branchManager().branchCount();
            return () -> Collections.singletonList(new BranchesSplit(rowCount, BranchesTable.this.location));
        }
    }
}

