/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyevaluator.RangerDefaultPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerRowFilterPolicyItemEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.util.RangerRequestExprResolver;

public class RangerDefaultRowFilterPolicyItemEvaluator
extends RangerDefaultPolicyItemEvaluator
implements RangerRowFilterPolicyItemEvaluator {
    private final RangerPolicy.RangerRowFilterPolicyItem rowFilterPolicyItem;
    private final String rowFilterExpr;
    private final RangerRequestExprResolver exprResolver;

    public RangerDefaultRowFilterPolicyItemEvaluator(RangerServiceDef serviceDef, RangerPolicy policy, RangerPolicy.RangerRowFilterPolicyItem policyItem, int policyItemIndex, RangerPolicyEngineOptions options) {
        super(serviceDef, policy, policyItem, 4, policyItemIndex, options);
        this.rowFilterPolicyItem = policyItem;
        RangerPolicy.RangerPolicyItemRowFilterInfo rowFilterInfo = this.getRowFilterInfo();
        this.rowFilterExpr = rowFilterInfo != null && rowFilterInfo.getFilterExpr() != null ? rowFilterInfo.getFilterExpr() : null;
        this.exprResolver = this.rowFilterExpr != null && RangerRequestExprResolver.hasExpressions(this.rowFilterExpr) ? new RangerRequestExprResolver(this.rowFilterExpr, this.getServiceType()) : null;
    }

    @Override
    public RangerPolicy.RangerPolicyItemRowFilterInfo getRowFilterInfo() {
        return this.rowFilterPolicyItem == null ? null : this.rowFilterPolicyItem.getRowFilterInfo();
    }

    @Override
    public void updateAccessResult(RangerPolicyEvaluator policyEvaluator, RangerAccessResult result, RangerPolicyResourceMatcher.MatchType matchType) {
        if (result.getFilterExpr() == null) {
            if (this.exprResolver != null) {
                result.setFilterExpr(this.exprResolver.resolveExpressions(result.getAccessRequest()));
            } else if (this.rowFilterExpr != null) {
                result.setFilterExpr(this.rowFilterExpr);
            }
            if (result.getFilterExpr() != null) {
                policyEvaluator.updateAccessResult(result, matchType, true, this.getComments());
                result.setIsAccessDetermined(true);
            }
        }
    }
}

