/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import org.apache.iceberg.PendingUpdate;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.SnapshotUtil;

class UpdateSnapshotReferencesOperation
implements PendingUpdate<Map<String, SnapshotRef>> {
    private final TableOperations ops;
    private final Map<String, SnapshotRef> updatedRefs;
    private TableMetadata base;

    UpdateSnapshotReferencesOperation(TableOperations ops) {
        this.ops = ops;
        this.base = ops.current();
        this.updatedRefs = Maps.newHashMap(this.base.refs());
    }

    public Map<String, SnapshotRef> apply() {
        return this.updatedRefs;
    }

    public void commit() {
        TableMetadata updated = this.internalApply();
        this.ops.commit(this.base, updated);
    }

    public UpdateSnapshotReferencesOperation createBranch(String name, long snapshotId) {
        Preconditions.checkNotNull((Object)name, (Object)"Branch name cannot be null");
        SnapshotRef branch = SnapshotRef.branchBuilder((long)snapshotId).build();
        SnapshotRef existingRef = this.updatedRefs.put(name, branch);
        Preconditions.checkArgument((existingRef == null ? 1 : 0) != 0, (String)"Ref %s already exists", (Object)name);
        return this;
    }

    public UpdateSnapshotReferencesOperation createTag(String name, long snapshotId) {
        Preconditions.checkNotNull((Object)name, (Object)"Tag name cannot be null");
        SnapshotRef tag = SnapshotRef.tagBuilder((long)snapshotId).build();
        SnapshotRef existingRef = this.updatedRefs.put(name, tag);
        Preconditions.checkArgument((existingRef == null ? 1 : 0) != 0, (String)"Ref %s already exists", (Object)name);
        return this;
    }

    public UpdateSnapshotReferencesOperation removeBranch(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Branch name cannot be null");
        Preconditions.checkArgument((!name.equals("main") ? 1 : 0) != 0, (Object)"Cannot remove main branch");
        SnapshotRef ref = this.updatedRefs.remove(name);
        Preconditions.checkArgument((ref != null ? 1 : 0) != 0, (String)"Branch does not exist: %s", (Object)name);
        Preconditions.checkArgument((boolean)ref.isBranch(), (String)"Ref %s is a tag not a branch", (Object)name);
        return this;
    }

    public UpdateSnapshotReferencesOperation removeTag(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Tag name cannot be null");
        SnapshotRef ref = this.updatedRefs.remove(name);
        Preconditions.checkArgument((ref != null ? 1 : 0) != 0, (String)"Tag does not exist: %s", (Object)name);
        Preconditions.checkArgument((boolean)ref.isTag(), (String)"Ref %s is a branch not a tag", (Object)name);
        return this;
    }

    public UpdateSnapshotReferencesOperation renameBranch(String name, String newName) {
        Preconditions.checkNotNull((Object)name, (Object)"Branch to rename cannot be null");
        Preconditions.checkNotNull((Object)newName, (Object)"New branch name cannot be null");
        Preconditions.checkArgument((!name.equals("main") ? 1 : 0) != 0, (Object)"Cannot rename main branch");
        SnapshotRef ref = this.updatedRefs.get(name);
        Preconditions.checkArgument((ref != null ? 1 : 0) != 0, (String)"Branch does not exist: %s", (Object)name);
        Preconditions.checkArgument((boolean)ref.isBranch(), (String)"Ref %s is a tag not a branch", (Object)name);
        SnapshotRef existing = this.updatedRefs.put(newName, ref);
        Preconditions.checkArgument((existing == null ? 1 : 0) != 0, (String)"Ref %s already exists", (Object)newName);
        this.updatedRefs.remove(name, ref);
        return this;
    }

    public UpdateSnapshotReferencesOperation replaceBranch(String name, long snapshotId) {
        Preconditions.checkNotNull((Object)name, (Object)"Branch name cannot be null");
        SnapshotRef ref = this.updatedRefs.get(name);
        Preconditions.checkArgument((ref != null ? 1 : 0) != 0, (String)"Branch does not exist: %s", (Object)name);
        Preconditions.checkArgument((boolean)ref.isBranch(), (String)"Ref %s is a tag not a branch", (Object)name);
        SnapshotRef updatedRef = SnapshotRef.builderFrom((SnapshotRef)ref, (long)snapshotId).build();
        this.updatedRefs.put(name, updatedRef);
        return this;
    }

    public UpdateSnapshotReferencesOperation replaceBranch(String from, String to) {
        return this.replaceBranch(from, to, false);
    }

    public UpdateSnapshotReferencesOperation fastForward(String from, String to) {
        return this.replaceBranch(from, to, true);
    }

    private UpdateSnapshotReferencesOperation replaceBranch(String from, String to, boolean fastForward) {
        Preconditions.checkNotNull((Object)from, (Object)"Branch to update cannot be null");
        Preconditions.checkNotNull((Object)to, (Object)"Destination ref cannot be null");
        SnapshotRef branchToUpdate = this.updatedRefs.get(from);
        SnapshotRef toRef = this.updatedRefs.get(to);
        Preconditions.checkArgument((toRef != null ? 1 : 0) != 0, (String)"Ref does not exist: %s", (Object)to);
        if (branchToUpdate == null) {
            return this.createBranch(from, toRef.snapshotId());
        }
        Preconditions.checkArgument((boolean)branchToUpdate.isBranch(), (String)"Ref %s is a tag not a branch", (Object)from);
        if (toRef.snapshotId() == branchToUpdate.snapshotId()) {
            return this;
        }
        SnapshotRef updatedRef = SnapshotRef.builderFrom((SnapshotRef)branchToUpdate, (long)toRef.snapshotId()).build();
        if (fastForward) {
            boolean targetIsAncestor = SnapshotUtil.isAncestorOf(toRef.snapshotId(), branchToUpdate.snapshotId(), this.base::snapshot);
            Preconditions.checkArgument((boolean)targetIsAncestor, (String)"Cannot fast-forward: %s is not an ancestor of %s", (Object)from, (Object)to);
        }
        this.updatedRefs.put(from, updatedRef);
        return this;
    }

    public UpdateSnapshotReferencesOperation replaceTag(String name, long snapshotId) {
        Preconditions.checkNotNull((Object)name, (Object)"Tag name cannot be null");
        SnapshotRef ref = this.updatedRefs.get(name);
        Preconditions.checkArgument((ref != null ? 1 : 0) != 0, (String)"Tag does not exist: %s", (Object)name);
        Preconditions.checkArgument((boolean)ref.isTag(), (String)"Ref %s is a branch not a tag", (Object)name);
        SnapshotRef updatedRef = SnapshotRef.builderFrom((SnapshotRef)ref, (long)snapshotId).build();
        this.updatedRefs.put(name, updatedRef);
        return this;
    }

    public UpdateSnapshotReferencesOperation setMinSnapshotsToKeep(String name, int minSnapshotsToKeep) {
        Preconditions.checkNotNull((Object)name, (Object)"Branch name cannot be null");
        SnapshotRef ref = this.updatedRefs.get(name);
        Preconditions.checkArgument((ref != null ? 1 : 0) != 0, (String)"Branch does not exist: %s", (Object)name);
        SnapshotRef updateBranch = SnapshotRef.builderFrom((SnapshotRef)ref).minSnapshotsToKeep(Integer.valueOf(minSnapshotsToKeep)).build();
        this.updatedRefs.put(name, updateBranch);
        return this;
    }

    public UpdateSnapshotReferencesOperation setMaxSnapshotAgeMs(String name, long maxSnapshotAgeMs) {
        Preconditions.checkNotNull((Object)name, (Object)"Branch name cannot be null");
        SnapshotRef ref = this.updatedRefs.get(name);
        Preconditions.checkArgument((ref != null ? 1 : 0) != 0, (String)"Branch does not exist: %s", (Object)name);
        SnapshotRef updateBranch = SnapshotRef.builderFrom((SnapshotRef)ref).maxSnapshotAgeMs(Long.valueOf(maxSnapshotAgeMs)).build();
        this.updatedRefs.put(name, updateBranch);
        return this;
    }

    public UpdateSnapshotReferencesOperation setMaxRefAgeMs(String name, long maxRefAgeMs) {
        Preconditions.checkNotNull((Object)name, (Object)"Reference name cannot be null");
        SnapshotRef ref = this.updatedRefs.get(name);
        Preconditions.checkArgument((ref != null ? 1 : 0) != 0, (String)"Ref does not exist: %s", (Object)name);
        SnapshotRef updatedRef = SnapshotRef.builderFrom((SnapshotRef)ref).maxRefAgeMs(Long.valueOf(maxRefAgeMs)).build();
        this.updatedRefs.put(name, updatedRef);
        return this;
    }

    private TableMetadata internalApply() {
        TableMetadata.Builder updatedBuilder = TableMetadata.buildFrom(this.base);
        Map<String, SnapshotRef> currRefs = this.base.refs();
        for (Map.Entry<String, SnapshotRef> currRefEntry : currRefs.entrySet()) {
            if (this.updatedRefs.containsKey(currRefEntry.getKey())) continue;
            updatedBuilder.removeRef(currRefEntry.getKey());
        }
        for (Map.Entry<String, SnapshotRef> newRefEntry : this.updatedRefs.entrySet()) {
            String name = newRefEntry.getKey();
            SnapshotRef currRef = currRefs.get(name);
            SnapshotRef updatedRef = this.updatedRefs.get(name);
            if (currRef != null && currRef.equals((Object)updatedRef)) continue;
            updatedBuilder.setRef(name, updatedRef);
        }
        return updatedBuilder.build();
    }
}

