/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.authorization;

import java.util.Collections;
import java.util.List;
import org.apache.gravitino.Audit;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class GroupDTO
implements Group {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="audit")
    private AuditDTO audit;
    @JsonProperty(value="roles")
    private List<String> roles;

    protected GroupDTO() {
    }

    protected GroupDTO(String name, List<String> roles, AuditDTO audit) {
        this.name = name;
        this.audit = audit;
        this.roles = roles;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<String> roles() {
        return this.roles;
    }

    @Override
    public Audit auditInfo() {
        return this.audit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<S extends Builder> {
        protected String name;
        protected List<String> roles = Collections.emptyList();
        protected AuditDTO audit;

        public S withName(String name) {
            this.name = name;
            return (S)this;
        }

        public S withRoles(List<String> roles) {
            if (roles != null) {
                this.roles = roles;
            }
            return (S)this;
        }

        public S withAudit(AuditDTO audit) {
            this.audit = audit;
            return (S)this;
        }

        public GroupDTO build() {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.name), "name cannot be null or empty");
            Preconditions.checkArgument(this.audit != null, "audit cannot be null");
            return new GroupDTO(this.name, this.roles, this.audit);
        }
    }
}

