/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.redis.lock;

import org.apache.seata.common.executor.Initialize;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.lock.Locker;
import org.apache.seata.server.lock.AbstractLockManager;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.storage.redis.lock.RedisLockerFactory;

@LoadLevel(name="redis")
public class RedisLockManager
extends AbstractLockManager
implements Initialize {
    private Locker locker;

    public void init() {
        this.locker = RedisLockerFactory.getLocker();
    }

    public Locker getLocker(BranchSession branchSession) {
        return this.locker;
    }

    public boolean releaseLock(BranchSession branchSession) throws TransactionException {
        try {
            return this.getLocker().releaseLock(branchSession.getXid(), Long.valueOf(branchSession.getBranchId()));
        }
        catch (Exception t) {
            LOGGER.error("unLock error, xid {}, branchId:{}", new Object[]{branchSession.getXid(), branchSession.getBranchId(), t});
            return false;
        }
    }

    public boolean releaseGlobalSessionLock(GlobalSession globalSession) throws TransactionException {
        try {
            return this.getLocker().releaseLock(globalSession.getXid());
        }
        catch (Exception t) {
            LOGGER.error("unLock globalSession error, xid:{}", (Object)globalSession.getXid(), (Object)t);
            return false;
        }
    }
}

