/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.io;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLoader.class);

    public static File load(String name) {
        try {
            if (name == null) {
                throw new IllegalArgumentException("name can't be null");
            }
            String decodedPath = URLDecoder.decode(name, StandardCharsets.UTF_8.name());
            return FileLoader.getFileFromFileSystem(decodedPath);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("decode name error: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private static File getFileFromFileSystem(String decodedPath) {
        URL resourceUrl = FileLoader.class.getClassLoader().getResource("");
        String[] tryPaths = resourceUrl != null ? new String[]{resourceUrl.getPath() + decodedPath, decodedPath} : new String[]{decodedPath};
        for (String tryPath : tryPaths) {
            File targetFile = new File(tryPath);
            if (!targetFile.exists()) continue;
            return targetFile;
        }
        return null;
    }
}

