/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.fury.logging.Logger;
import org.apache.fury.logging.LoggerFactory;
import org.apache.fury.util.unsafe.DefineClass;

public class ClassLoaderUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoaderUtils.class);

    public static Class<?> tryDefineClassesInClassLoader(String className, Class<?> neighbor, ClassLoader classLoader, byte[] bytecode) {
        ProtectionDomain domain = neighbor != null ? neighbor.getProtectionDomain() : classLoader.getClass().getProtectionDomain();
        return ClassLoaderUtils.tryDefineClassesInClassLoader(className, neighbor, classLoader, domain, bytecode);
    }

    public static Class<?> tryDefineClassesInClassLoader(String className, Class<?> neighbor, ClassLoader classLoader, ProtectionDomain domain, byte[] bytecode) {
        try {
            if (classLoader instanceof ByteArrayClassLoader) {
                return ((ByteArrayClassLoader)classLoader).defineClassPublic(className, bytecode, domain);
            }
            return DefineClass.defineClass(className, neighbor, classLoader, domain, bytecode);
        }
        catch (Exception | LinkageError e) {
            return null;
        }
    }

    public static class ByteArrayClassLoader
    extends ClassLoader {
        private final boolean childFirst;
        private final ParentClassLoader parent;
        private final Map<String, byte[]> classes;

        public ByteArrayClassLoader(Map<String, byte[]> classes) {
            this(classes, ByteArrayClassLoader.class.getClassLoader(), false);
        }

        public ByteArrayClassLoader(Map<String, byte[]> classes, ClassLoader parent) {
            this(classes, parent, false);
        }

        public ByteArrayClassLoader(Map<String, byte[]> classes, ClassLoader parent, boolean childFirst) {
            super(childFirst ? null : parent);
            this.childFirst = childFirst;
            this.parent = new ParentClassLoader(parent);
            this.classes = new ConcurrentHashMap<String, byte[]>(classes);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] bytecodes = this.classes.get(name);
            if (bytecodes == null && (bytecodes = this.classes.get(name.replace('.', '/') + ".class")) == null) {
                throw new ClassNotFoundException(name);
            }
            return super.defineClass(name, bytecodes, 0, bytecodes.length, this.getClass().getProtectionDomain());
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.childFirst) {
                try {
                    return super.loadClass(name, resolve);
                }
                catch (ClassNotFoundException cnf) {
                    return Objects.requireNonNull(this.parent).loadClass(name, resolve);
                }
            }
            return super.loadClass(name, resolve);
        }

        public Class<?> defineClassPublic(String name, byte[] b) {
            return this.defineClassPublic(name, b, this.getClass().getProtectionDomain());
        }

        public Class<?> defineClassPublic(String name, byte[] b, ProtectionDomain protectionDomain) throws ClassFormatError {
            return super.defineClass(name, b, 0, b.length, protectionDomain);
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }

    public static class ComposedClassLoader
    extends URLClassLoader {
        private final List<ParentClassLoader> parentClassloaders;

        public ComposedClassLoader(ClassLoader[] classLoaders) {
            super(new URL[0], (ClassLoader)null);
            this.parentClassloaders = Arrays.stream(classLoaders).map(ParentClassLoader::new).collect(Collectors.toList());
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            for (ParentClassLoader classLoader : this.parentClassloaders) {
                try {
                    return classLoader.loadClass(name, resolve);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            return super.loadClass(name, resolve);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (ParentClassLoader classLoader : this.parentClassloaders) {
                urls.addAll(Collections.list(classLoader.getResources(name)));
            }
            urls.addAll(Collections.list(super.getResources(name)));
            return Collections.enumeration(urls);
        }

        @Override
        public URL getResource(String name) {
            for (ParentClassLoader classLoader : this.parentClassloaders) {
                URL url = classLoader.getResource(name);
                if (url == null) continue;
                return url;
            }
            return super.getResource(name);
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }

    public static class ChildFirstURLClassLoader
    extends URLClassLoader {
        private ParentClassLoader parent;

        public ChildFirstURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, (ClassLoader)null);
            this.parent = new ParentClassLoader(parent);
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                return super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException cnf) {
                return this.parent.loadClass(name, resolve);
            }
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            ArrayList<URL> urls = Collections.list(super.getResources(name));
            urls.addAll(Collections.list(this.parent.getResources(name)));
            return Collections.enumeration(urls);
        }

        @Override
        public URL getResource(String name) {
            URL url = super.getResource(name);
            if (url != null) {
                return url;
            }
            return this.parent.getResource(name);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        static {
            ChildFirstURLClassLoader.registerAsParallelCapable();
        }
    }

    public static class ParentClassLoader
    extends ClassLoader {
        public ParentClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

