/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context;

import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.context.AbstractTracerContext;
import org.apache.skywalking.apm.agent.core.context.AsyncSpan;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.CorrelationContext;
import org.apache.skywalking.apm.agent.core.context.ExtensionContext;
import org.apache.skywalking.apm.agent.core.context.IgnoreTracerContextListener;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.NoopSpan;

public class IgnoredTracerContext
implements AbstractTracerContext {
    private static final NoopSpan NOOP_SPAN = new NoopSpan();
    private static final String IGNORE_TRACE = "Ignored_Trace";
    private final CorrelationContext correlationContext = new CorrelationContext();
    private final ExtensionContext extensionContext = new ExtensionContext();
    private int stackDepth = 0;

    @Override
    public void inject(ContextCarrier carrier) {
        this.correlationContext.inject(carrier);
    }

    @Override
    public void extract(ContextCarrier carrier) {
        this.correlationContext.extract(carrier);
    }

    @Override
    public ContextSnapshot capture() {
        return new ContextSnapshot(null, -1, null, null, this.correlationContext, this.extensionContext);
    }

    @Override
    public void continued(ContextSnapshot snapshot) {
        this.correlationContext.continued(snapshot);
    }

    @Override
    public String getReadablePrimaryTraceId() {
        return IGNORE_TRACE;
    }

    @Override
    public String getSegmentId() {
        return IGNORE_TRACE;
    }

    @Override
    public int getSpanId() {
        return -1;
    }

    @Override
    public AbstractSpan createEntrySpan(String operationName) {
        ++this.stackDepth;
        return NOOP_SPAN;
    }

    @Override
    public AbstractSpan createLocalSpan(String operationName) {
        ++this.stackDepth;
        return NOOP_SPAN;
    }

    @Override
    public AbstractSpan createExitSpan(String operationName, String remotePeer) {
        ++this.stackDepth;
        return NOOP_SPAN;
    }

    @Override
    public AbstractSpan activeSpan() {
        return NOOP_SPAN;
    }

    @Override
    public boolean stopSpan(AbstractSpan span) {
        --this.stackDepth;
        if (this.stackDepth == 0) {
            ListenerManager.notifyFinish(this);
        }
        return this.stackDepth == 0;
    }

    @Override
    public AbstractTracerContext awaitFinishAsync() {
        return this;
    }

    @Override
    public void asyncStop(AsyncSpan span) {
    }

    @Override
    public CorrelationContext getCorrelationContext() {
        return this.correlationContext;
    }

    public static class ListenerManager {
        private static List<IgnoreTracerContextListener> LISTENERS = new LinkedList<IgnoreTracerContextListener>();

        public static synchronized void add(IgnoreTracerContextListener listener) {
            LISTENERS.add(listener);
        }

        static void notifyFinish(IgnoredTracerContext ignoredTracerContext) {
            for (IgnoreTracerContextListener listener : LISTENERS) {
                listener.afterFinished(ignoredTracerContext);
            }
        }

        public static synchronized void remove(IgnoreTracerContextListener listener) {
            LISTENERS.remove(listener);
        }
    }
}

