/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.Set;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.JackrabbitIndexSearcher;
import org.apache.jackrabbit.core.query.lucene.JackrabbitQuery;
import org.apache.jackrabbit.core.query.lucene.MatchAllDocsQuery;
import org.apache.jackrabbit.core.query.lucene.QueryHits;
import org.apache.jackrabbit.core.query.lucene.hits.AbstractHitCollector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.Weight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DescendantSelfAxisQuery
extends Query
implements JackrabbitQuery {
    private static final Logger log = LoggerFactory.getLogger(DescendantSelfAxisQuery.class);
    private final Query contextQuery;
    private Scorer contextScorer;
    private final Query subQuery;
    private final int minLevels;
    private Scorer subScorer;

    public DescendantSelfAxisQuery(Query context, boolean includeSelf) {
        this(context, (Query)new MatchAllDocsQuery(), includeSelf);
    }

    public DescendantSelfAxisQuery(Query context, Query sub) {
        this(context, sub, true);
    }

    public DescendantSelfAxisQuery(Query context, Query sub, boolean includeSelf) {
        this(context, sub, includeSelf ? 0 : 1);
    }

    public DescendantSelfAxisQuery(Query context, Query sub, int minLevels) {
        this.contextQuery = context;
        this.subQuery = sub;
        this.minLevels = minLevels;
    }

    Query getContextQuery() {
        return this.contextQuery;
    }

    boolean subQueryMatchesAll() {
        return this.subQuery instanceof MatchAllDocsQuery;
    }

    int getMinLevels() {
        return this.minLevels;
    }

    @Override
    public Weight createWeight(Searcher searcher) {
        return new DescendantSelfAxisWeight(searcher);
    }

    @Override
    public String toString(String field) {
        StringBuffer sb = new StringBuffer();
        sb.append("DescendantSelfAxisQuery(");
        sb.append(this.contextQuery);
        sb.append(", ");
        sb.append(this.subQuery);
        sb.append(", ");
        sb.append(this.minLevels);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.contextQuery.extractTerms(terms);
        this.subQuery.extractTerms(terms);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        DescendantSelfAxisQuery dsaq;
        Query cQuery = this.contextQuery.rewrite(reader);
        Query sQuery = this.subQuery.rewrite(reader);
        if (this.contextQuery instanceof DescendantSelfAxisQuery && (dsaq = (DescendantSelfAxisQuery)this.contextQuery).subQueryMatchesAll()) {
            return new DescendantSelfAxisQuery(dsaq.getContextQuery(), sQuery, dsaq.getMinLevels() + this.getMinLevels()).rewrite(reader);
        }
        if (cQuery == this.contextQuery && sQuery == this.subQuery) {
            return this;
        }
        return new DescendantSelfAxisQuery(cQuery, sQuery, this.minLevels);
    }

    /*
     * Exception decompiling
     */
    @Override
    public QueryHits execute(JackrabbitIndexSearcher searcher, SessionImpl session, Sort sort) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class DescendantSelfAxisScorer
    extends Scorer {
        private final HierarchyResolver hResolver;
        private final BitSet contextHits;
        private boolean contextHitsCalculated;
        private int[] ancestorDocs;
        private int[] pDocs;
        private final int[] singleDoc;
        private int currentDoc;

        protected DescendantSelfAxisScorer(Similarity similarity, IndexReader reader, HierarchyResolver hResolver) {
            super(similarity);
            this.contextHitsCalculated = false;
            this.ancestorDocs = new int[2];
            this.pDocs = new int[1];
            this.singleDoc = new int[1];
            this.currentDoc = -1;
            this.hResolver = hResolver;
            this.contextHits = new BitSet(reader.maxDoc());
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.currentDoc == Integer.MAX_VALUE) {
                return this.currentDoc;
            }
            this.collectContextHits();
            this.currentDoc = this.contextHits.isEmpty() ? Integer.MAX_VALUE : (DescendantSelfAxisQuery.this.subScorer != null ? DescendantSelfAxisQuery.this.subScorer.nextDoc() : Integer.MAX_VALUE);
            while (this.currentDoc != Integer.MAX_VALUE) {
                if (this.isValid(this.currentDoc)) {
                    return this.currentDoc;
                }
                this.currentDoc = DescendantSelfAxisQuery.this.subScorer.nextDoc();
            }
            return this.currentDoc;
        }

        @Override
        public int docID() {
            return this.currentDoc;
        }

        @Override
        public float score() throws IOException {
            return DescendantSelfAxisQuery.this.subScorer.score();
        }

        @Override
        public int advance(int target) throws IOException {
            if (this.currentDoc == Integer.MAX_VALUE) {
                return this.currentDoc;
            }
            if (target == Integer.MAX_VALUE) {
                if (DescendantSelfAxisQuery.this.subScorer != null) {
                    DescendantSelfAxisQuery.this.subScorer.advance(target);
                }
                this.currentDoc = Integer.MAX_VALUE;
                return this.currentDoc;
            }
            this.currentDoc = DescendantSelfAxisQuery.this.subScorer.advance(target);
            if (this.currentDoc == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            this.collectContextHits();
            return this.isValid(this.currentDoc) ? this.currentDoc : this.nextDoc();
        }

        private void collectContextHits() throws IOException {
            if (!this.contextHitsCalculated) {
                long time = System.currentTimeMillis();
                if (DescendantSelfAxisQuery.this.contextScorer != null) {
                    DescendantSelfAxisQuery.this.contextScorer.score(new AbstractHitCollector(){

                        @Override
                        protected void collect(int doc, float score) {
                            DescendantSelfAxisScorer.this.contextHits.set(doc);
                        }
                    });
                }
                this.contextHitsCalculated = true;
                time = System.currentTimeMillis() - time;
                if (log.isDebugEnabled()) {
                    log.debug("Collected {} context hits in {} ms for {}", this.contextHits.cardinality(), time, DescendantSelfAxisQuery.this);
                }
            }
        }

        private boolean isValid(int doc) throws IOException {
            if (DescendantSelfAxisQuery.this.minLevels == 0 && this.contextHits.get(doc)) {
                return true;
            }
            this.pDocs = this.hResolver.getParents(doc, this.pDocs);
            if (this.pDocs.length == 0) {
                return false;
            }
            int ancestorCount = 0;
            this.ancestorDocs[ancestorCount++] = this.pDocs[0];
            while (this.pDocs.length != 0) {
                boolean valid = false;
                for (int pDoc : this.pDocs) {
                    if (ancestorCount < DescendantSelfAxisQuery.this.minLevels || !this.contextHits.get(pDoc)) continue;
                    valid = true;
                    break;
                }
                if (valid) break;
                this.pDocs = this.getParents(this.pDocs, this.singleDoc);
                if (ancestorCount == this.ancestorDocs.length) {
                    int[] copy = new int[this.ancestorDocs.length * 2];
                    System.arraycopy(this.ancestorDocs, 0, copy, 0, this.ancestorDocs.length);
                    this.ancestorDocs = copy;
                }
                if (this.pDocs.length == 0) continue;
                this.ancestorDocs[ancestorCount++] = this.pDocs[0];
            }
            if (this.pDocs.length > 0) {
                for (int i = 0; i < ancestorCount; ++i) {
                    this.contextHits.set(this.ancestorDocs[i]);
                }
                return true;
            }
            return false;
        }

        private int[] getParents(int[] docs, int[] pDocs) throws IOException {
            if (docs.length == 1) {
                return this.hResolver.getParents(docs[0], pDocs);
            }
            pDocs = new int[]{};
            for (int doc : docs) {
                int[] p = this.hResolver.getParents(doc, new int[0]);
                int[] tmp = new int[p.length + pDocs.length];
                System.arraycopy(pDocs, 0, tmp, 0, pDocs.length);
                System.arraycopy(p, 0, tmp, pDocs.length, p.length);
                pDocs = tmp;
            }
            return pDocs;
        }
    }

    private class DescendantSelfAxisWeight
    extends Weight {
        private final Searcher searcher;

        private DescendantSelfAxisWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        @Override
        public Query getQuery() {
            return DescendantSelfAxisQuery.this;
        }

        @Override
        public float getValue() {
            return 1.0f;
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        @Override
        public void normalize(float norm) {
        }

        @Override
        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            DescendantSelfAxisQuery.this.contextScorer = this.searcher.createNormalizedWeight(DescendantSelfAxisQuery.this.contextQuery).scorer(reader, scoreDocsInOrder, false);
            DescendantSelfAxisQuery.this.subScorer = this.searcher.createNormalizedWeight(DescendantSelfAxisQuery.this.subQuery).scorer(reader, scoreDocsInOrder, false);
            HierarchyResolver resolver = (HierarchyResolver)((Object)reader);
            return new DescendantSelfAxisScorer(this.searcher.getSimilarity(), reader, resolver);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

