/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.retention;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.retention.Hold;
import javax.jcr.retention.RetentionPolicy;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.retention.HoldImpl;
import org.apache.jackrabbit.core.retention.RetentionManagerImpl;
import org.apache.jackrabbit.core.retention.RetentionPolicyImpl;
import org.apache.jackrabbit.core.retention.RetentionRegistry;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.PathMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetentionRegistryImpl
implements RetentionRegistry,
SynchronousEventListener {
    private static final Logger log = LoggerFactory.getLogger(RetentionRegistryImpl.class);
    private static final String FILE_NAME = "retention";
    private final PathMap<RetentionPolicyImpl> retentionMap = new PathMap();
    private final PathMap<List<HoldImpl>> holdMap = new PathMap();
    private final SessionImpl session;
    private final FileSystemResource retentionFile;
    private long holdCnt;
    private long retentionCnt;
    private boolean initialized;

    public RetentionRegistryImpl(SessionImpl session, FileSystem fs) throws RepositoryException {
        this.session = session;
        this.retentionFile = new FileSystemResource(fs, "/retention");
        Workspace wsp = session.getWorkspace();
        int types = 28;
        String[] ntFilter = new String[]{session.getJCRName(RetentionManagerImpl.REP_RETENTION_MANAGEABLE)};
        wsp.getObservationManager().addEventListener(this, types, "/", true, null, ntFilter, false);
        try {
            this.readRetentionFile();
        }
        catch (FileSystemException e) {
            throw new RepositoryException("Error while reading retention/holds from '" + this.retentionFile.getPath() + "'", e);
        }
        catch (IOException e) {
            throw new RepositoryException("Error while reading retention/holds from '" + this.retentionFile.getPath() + "'", e);
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRetentionFile() throws IOException, FileSystemException {
        if (this.retentionFile.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(this.retentionFile.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    NodeId nodeId = NodeId.valueOf(line);
                    try {
                        PropertyImpl prop;
                        NodeImpl node = (NodeImpl)this.session.getItemManager().getItem(nodeId);
                        Path nodePath = node.getPrimaryPath();
                        if (node.hasProperty(RetentionManagerImpl.REP_HOLD)) {
                            prop = node.getProperty(RetentionManagerImpl.REP_HOLD);
                            this.addHolds(nodePath, prop);
                        }
                        if (!node.hasProperty(RetentionManagerImpl.REP_RETENTION_POLICY)) continue;
                        prop = node.getProperty(RetentionManagerImpl.REP_RETENTION_POLICY);
                        this.addRetentionPolicy(nodePath, prop);
                    }
                    catch (RepositoryException e) {
                        log.warn("Unable to read retention policy / holds from node '" + String.valueOf(nodeId) + "': " + e.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeRetentionFile() {
        final HashSet nodeIds = new HashSet();
        this.holdMap.traverse(new PathMap.ElementVisitor<List<HoldImpl>>(){

            @Override
            public void elementVisited(PathMap.Element<List<HoldImpl>> element) {
                List<HoldImpl> holds = element.get();
                if (!holds.isEmpty()) {
                    nodeIds.add(holds.get(0).getNodeId());
                }
            }
        }, false);
        this.retentionMap.traverse(new PathMap.ElementVisitor<RetentionPolicyImpl>(){

            @Override
            public void elementVisited(PathMap.Element<RetentionPolicyImpl> element) {
                nodeIds.add(element.get().getNodeId());
            }
        }, false);
        if (!nodeIds.isEmpty()) {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter(this.retentionFile.getOutputStream()));
                Iterator it = nodeIds.iterator();
                while (it.hasNext()) {
                    writer.write(((NodeId)it.next()).toString());
                    if (!it.hasNext()) continue;
                    writer.newLine();
                }
            }
            catch (FileSystemException fse) {
                log.error("Error while saving locks to '" + this.retentionFile.getPath() + "': " + fse.getMessage());
                IOUtils.closeQuietly(writer);
            }
            catch (IOException ioe) {
                log.error("Error while saving locks to '" + this.retentionFile.getPath() + "': " + ioe.getMessage());
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(writer);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(writer);
            }
            IOUtils.closeQuietly(writer);
        }
    }

    public void close() {
        this.writeRetentionFile();
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHolds(Path nodePath, PropertyImpl p) throws RepositoryException {
        PathMap<List<HoldImpl>> pathMap = this.holdMap;
        synchronized (pathMap) {
            HoldImpl[] holds = HoldImpl.createFromProperty(p, ((PropertyId)p.getId()).getParentId());
            this.holdMap.put(nodePath, Arrays.asList(holds));
            ++this.holdCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHolds(Path nodePath) {
        PathMap<List<HoldImpl>> pathMap = this.holdMap;
        synchronized (pathMap) {
            PathMap.Element<List<HoldImpl>> el = this.holdMap.map(nodePath, true);
            if (el != null) {
                el.remove();
                --this.holdCnt;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRetentionPolicy(Path nodePath, PropertyImpl p) throws RepositoryException {
        PathMap<RetentionPolicyImpl> pathMap = this.retentionMap;
        synchronized (pathMap) {
            RetentionPolicyImpl rp = new RetentionPolicyImpl(p.getString(), ((PropertyId)p.getId()).getParentId(), (NameResolver)this.session);
            this.retentionMap.put(nodePath, rp);
            ++this.retentionCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRetentionPolicy(Path nodePath) {
        PathMap<RetentionPolicyImpl> pathMap = this.retentionMap;
        synchronized (pathMap) {
            PathMap.Element<RetentionPolicyImpl> el = this.retentionMap.map(nodePath, true);
            if (el != null) {
                el.remove();
                --this.retentionCnt;
            }
        }
    }

    @Override
    public boolean hasEffectiveHold(Path nodePath, boolean checkParent) throws RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized.");
        }
        if (this.holdCnt <= 0L) {
            return false;
        }
        PathMap.Element<List<HoldImpl>> element = this.holdMap.map(nodePath, false);
        List<HoldImpl> holds = element.get();
        if (holds != null) {
            if (element.hasPath(nodePath)) {
                return true;
            }
            if (checkParent && !nodePath.denotesRoot() && element.hasPath(nodePath.getAncestor(1))) {
                return true;
            }
            for (Hold hold : holds) {
                if (!hold.isDeep()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasEffectiveRetention(Path nodePath, boolean checkParent) throws RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized.");
        }
        if (this.retentionCnt <= 0L) {
            return false;
        }
        RetentionPolicy rp = null;
        PathMap.Element<RetentionPolicyImpl> element = this.retentionMap.map(nodePath, true);
        if (element != null) {
            rp = element.get();
        }
        if (rp == null && checkParent && !nodePath.denotesRoot() && (element = this.retentionMap.map(nodePath.getAncestor(1), true)) != null) {
            rp = element.get();
        }
        return rp != null;
    }

    @Override
    public void onEvent(EventIterator events) {
        while (events.hasNext()) {
            Event ev = events.nextEvent();
            try {
                PropertyImpl p;
                Path evPath = this.session.getQPath(ev.getPath());
                Path nodePath = evPath.getAncestor(1);
                Name propName = evPath.getName();
                if (RetentionManagerImpl.REP_HOLD.equals(propName)) {
                    switch (ev.getType()) {
                        case 4: 
                        case 16: {
                            p = (PropertyImpl)this.session.getProperty(ev.getPath());
                            this.addHolds(nodePath, p);
                            break;
                        }
                        case 8: {
                            this.removeHolds(nodePath);
                        }
                    }
                    continue;
                }
                if (!RetentionManagerImpl.REP_RETENTION_POLICY.equals(propName)) continue;
                switch (ev.getType()) {
                    case 4: 
                    case 16: {
                        p = (PropertyImpl)this.session.getProperty(ev.getPath());
                        this.addRetentionPolicy(nodePath, p);
                        break;
                    }
                    case 8: {
                        this.removeRetentionPolicy(nodePath);
                    }
                }
            }
            catch (RepositoryException e) {
                log.warn("Internal error while processing event. {}", (Object)e.getMessage());
            }
        }
    }
}

