/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.principal;

import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;

public final class GroupPrincipals {
    private GroupPrincipals() {
    }

    public static boolean isGroup(Principal principal) {
        return principal instanceof GroupPrincipal;
    }

    public static Enumeration<? extends Principal> members(Principal principal) {
        if (principal instanceof GroupPrincipal) {
            return ((GroupPrincipal)principal).members();
        }
        return Collections.emptyEnumeration();
    }

    public static boolean isMember(Principal principal, Principal member) {
        if (principal instanceof GroupPrincipal) {
            return ((GroupPrincipal)principal).isMember(member);
        }
        return false;
    }
}

