/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser.annotation;

import java.nio.charset.Charset;
import org.apache.juneau.ConfigApply;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.annotation.ParserConfig;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class ParserConfigApply
extends ConfigApply<ParserConfig> {
    public ParserConfigApply(Class<ParserConfig> c, VarResolverSession r) {
        super(c, r);
    }

    @Override
    public void apply(AnnotationInfo<ParserConfig> ai, PropertyStoreBuilder psb) {
        ParserConfig a = ai.getAnnotation();
        if (!a.autoCloseStreams().isEmpty()) {
            psb.set("Parser.autoCloseStreams.b", this.bool(a.autoCloseStreams()));
        }
        if (!a.debugOutputLines().isEmpty()) {
            psb.set("Parser.debugOutputLines.i", this.integer(a.debugOutputLines(), "debugOutputLines"));
        }
        if (a.listener() != ParserListener.Null.class) {
            psb.set("Parser.listener.c", a.listener());
        }
        if (!a.strict().isEmpty()) {
            psb.set("Parser.strict.b", this.bool(a.strict()));
        }
        if (!a.trimStrings().isEmpty()) {
            psb.set("Parser.trimStrings.b", this.bool(a.trimStrings()));
        }
        if (!a.unbuffered().isEmpty()) {
            psb.set("Parser.unbuffered.b", this.bool(a.unbuffered()));
        }
        if (!a.binaryFormat().isEmpty()) {
            psb.set("InputStreamParser.binaryFormat.s", this.string(a.binaryFormat()));
        }
        if (!a.fileCharset().isEmpty()) {
            psb.set("ReaderParser.fileCharset.s", this.charset(a.fileCharset()));
        }
        if (!a.streamCharset().isEmpty()) {
            psb.set("ReaderParser.streamCharset.s", this.charset(a.streamCharset()));
        }
    }

    private Object charset(String in) {
        String s = this.string(in);
        if ("default".equalsIgnoreCase(s)) {
            return Charset.defaultCharset();
        }
        return s;
    }
}

