/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.log.metrics;

import com.yammer.metrics.core.Meter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;

public final class BrokerTopicMetrics {
    public static final String MESSAGE_IN_PER_SEC = "MessagesInPerSec";
    public static final String BYTES_IN_PER_SEC = "BytesInPerSec";
    public static final String BYTES_OUT_PER_SEC = "BytesOutPerSec";
    public static final String BYTES_REJECTED_PER_SEC = "BytesRejectedPerSec";
    public static final String REPLICATION_BYTES_IN_PER_SEC = "ReplicationBytesInPerSec";
    public static final String REPLICATION_BYTES_OUT_PER_SEC = "ReplicationBytesOutPerSec";
    public static final String FAILED_PRODUCE_REQUESTS_PER_SEC = "FailedProduceRequestsPerSec";
    public static final String FAILED_FETCH_REQUESTS_PER_SEC = "FailedFetchRequestsPerSec";
    public static final String TOTAL_PRODUCE_REQUESTS_PER_SEC = "TotalProduceRequestsPerSec";
    public static final String TOTAL_FETCH_REQUESTS_PER_SEC = "TotalFetchRequestsPerSec";
    public static final String FETCH_MESSAGE_CONVERSIONS_PER_SEC = "FetchMessageConversionsPerSec";
    public static final String PRODUCE_MESSAGE_CONVERSIONS_PER_SEC = "ProduceMessageConversionsPerSec";
    public static final String REASSIGNMENT_BYTES_IN_PER_SEC = "ReassignmentBytesInPerSec";
    public static final String REASSIGNMENT_BYTES_OUT_PER_SEC = "ReassignmentBytesOutPerSec";
    public static final String NO_KEY_COMPACTED_TOPIC_RECORDS_PER_SEC = "NoKeyCompactedTopicRecordsPerSec";
    public static final String INVALID_MAGIC_NUMBER_RECORDS_PER_SEC = "InvalidMagicNumberRecordsPerSec";
    public static final String INVALID_MESSAGE_CRC_RECORDS_PER_SEC = "InvalidMessageCrcRecordsPerSec";
    public static final String INVALID_OFFSET_OR_SEQUENCE_RECORDS_PER_SEC = "InvalidOffsetOrSequenceRecordsPerSec";
    private final KafkaMetricsGroup metricsGroup = new KafkaMetricsGroup("kafka.server", "BrokerTopicMetrics");
    private final Map<String, String> tags;
    private final Map<String, MeterWrapper> metricTypeMap = new HashMap<String, MeterWrapper>();
    private final Map<String, GaugeWrapper> metricGaugeTypeMap = new HashMap<String, GaugeWrapper>();

    public BrokerTopicMetrics(boolean remoteStorageEnabled) {
        this(Optional.empty(), remoteStorageEnabled);
    }

    public BrokerTopicMetrics(String name, boolean remoteStorageEnabled) {
        this(Optional.of(name), remoteStorageEnabled);
    }

    private BrokerTopicMetrics(Optional<String> name, boolean remoteStorageEnabled) {
        this.tags = name.map(s -> Collections.singletonMap("topic", s)).orElse(Collections.emptyMap());
        this.metricTypeMap.put(MESSAGE_IN_PER_SEC, new MeterWrapper(MESSAGE_IN_PER_SEC, "messages"));
        this.metricTypeMap.put(BYTES_IN_PER_SEC, new MeterWrapper(BYTES_IN_PER_SEC, "bytes"));
        this.metricTypeMap.put(BYTES_OUT_PER_SEC, new MeterWrapper(BYTES_OUT_PER_SEC, "bytes"));
        this.metricTypeMap.put(BYTES_REJECTED_PER_SEC, new MeterWrapper(BYTES_REJECTED_PER_SEC, "bytes"));
        this.metricTypeMap.put(FAILED_PRODUCE_REQUESTS_PER_SEC, new MeterWrapper(FAILED_PRODUCE_REQUESTS_PER_SEC, "requests"));
        this.metricTypeMap.put(FAILED_FETCH_REQUESTS_PER_SEC, new MeterWrapper(FAILED_FETCH_REQUESTS_PER_SEC, "requests"));
        this.metricTypeMap.put(TOTAL_PRODUCE_REQUESTS_PER_SEC, new MeterWrapper(TOTAL_PRODUCE_REQUESTS_PER_SEC, "requests"));
        this.metricTypeMap.put(TOTAL_FETCH_REQUESTS_PER_SEC, new MeterWrapper(TOTAL_FETCH_REQUESTS_PER_SEC, "requests"));
        this.metricTypeMap.put(FETCH_MESSAGE_CONVERSIONS_PER_SEC, new MeterWrapper(FETCH_MESSAGE_CONVERSIONS_PER_SEC, "requests"));
        this.metricTypeMap.put(PRODUCE_MESSAGE_CONVERSIONS_PER_SEC, new MeterWrapper(PRODUCE_MESSAGE_CONVERSIONS_PER_SEC, "requests"));
        this.metricTypeMap.put(NO_KEY_COMPACTED_TOPIC_RECORDS_PER_SEC, new MeterWrapper(NO_KEY_COMPACTED_TOPIC_RECORDS_PER_SEC, "requests"));
        this.metricTypeMap.put(INVALID_MAGIC_NUMBER_RECORDS_PER_SEC, new MeterWrapper(INVALID_MAGIC_NUMBER_RECORDS_PER_SEC, "requests"));
        this.metricTypeMap.put(INVALID_MESSAGE_CRC_RECORDS_PER_SEC, new MeterWrapper(INVALID_MESSAGE_CRC_RECORDS_PER_SEC, "requests"));
        this.metricTypeMap.put(INVALID_OFFSET_OR_SEQUENCE_RECORDS_PER_SEC, new MeterWrapper(INVALID_OFFSET_OR_SEQUENCE_RECORDS_PER_SEC, "requests"));
        if (!name.isPresent()) {
            this.metricTypeMap.put(REPLICATION_BYTES_IN_PER_SEC, new MeterWrapper(REPLICATION_BYTES_IN_PER_SEC, "bytes"));
            this.metricTypeMap.put(REPLICATION_BYTES_OUT_PER_SEC, new MeterWrapper(REPLICATION_BYTES_OUT_PER_SEC, "bytes"));
            this.metricTypeMap.put(REASSIGNMENT_BYTES_IN_PER_SEC, new MeterWrapper(REASSIGNMENT_BYTES_IN_PER_SEC, "bytes"));
            this.metricTypeMap.put(REASSIGNMENT_BYTES_OUT_PER_SEC, new MeterWrapper(REASSIGNMENT_BYTES_OUT_PER_SEC, "bytes"));
        }
        if (remoteStorageEnabled) {
            this.metricTypeMap.put(RemoteStorageMetrics.REMOTE_COPY_BYTES_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.REMOTE_COPY_BYTES_PER_SEC_METRIC.getName(), "bytes"));
            this.metricTypeMap.put(RemoteStorageMetrics.REMOTE_FETCH_BYTES_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.REMOTE_FETCH_BYTES_PER_SEC_METRIC.getName(), "bytes"));
            this.metricTypeMap.put(RemoteStorageMetrics.REMOTE_FETCH_REQUESTS_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.REMOTE_FETCH_REQUESTS_PER_SEC_METRIC.getName(), "requests"));
            this.metricTypeMap.put(RemoteStorageMetrics.REMOTE_COPY_REQUESTS_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.REMOTE_COPY_REQUESTS_PER_SEC_METRIC.getName(), "requests"));
            this.metricTypeMap.put(RemoteStorageMetrics.REMOTE_DELETE_REQUESTS_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.REMOTE_DELETE_REQUESTS_PER_SEC_METRIC.getName(), "requests"));
            this.metricTypeMap.put(RemoteStorageMetrics.BUILD_REMOTE_LOG_AUX_STATE_REQUESTS_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.BUILD_REMOTE_LOG_AUX_STATE_REQUESTS_PER_SEC_METRIC.getName(), "requests"));
            this.metricTypeMap.put(RemoteStorageMetrics.FAILED_REMOTE_FETCH_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.FAILED_REMOTE_FETCH_PER_SEC_METRIC.getName(), "requests"));
            this.metricTypeMap.put(RemoteStorageMetrics.FAILED_REMOTE_COPY_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.FAILED_REMOTE_COPY_PER_SEC_METRIC.getName(), "requests"));
            this.metricTypeMap.put(RemoteStorageMetrics.FAILED_REMOTE_DELETE_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.FAILED_REMOTE_DELETE_PER_SEC_METRIC.getName(), "requests"));
            this.metricTypeMap.put(RemoteStorageMetrics.FAILED_BUILD_REMOTE_LOG_AUX_STATE_PER_SEC_METRIC.getName(), new MeterWrapper(RemoteStorageMetrics.FAILED_BUILD_REMOTE_LOG_AUX_STATE_PER_SEC_METRIC.getName(), "requests"));
            this.metricGaugeTypeMap.put(RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName(), new GaugeWrapper(RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName()));
            this.metricGaugeTypeMap.put(RemoteStorageMetrics.REMOTE_COPY_LAG_SEGMENTS_METRIC.getName(), new GaugeWrapper(RemoteStorageMetrics.REMOTE_COPY_LAG_SEGMENTS_METRIC.getName()));
            this.metricGaugeTypeMap.put(RemoteStorageMetrics.REMOTE_DELETE_LAG_BYTES_METRIC.getName(), new GaugeWrapper(RemoteStorageMetrics.REMOTE_DELETE_LAG_BYTES_METRIC.getName()));
            this.metricGaugeTypeMap.put(RemoteStorageMetrics.REMOTE_DELETE_LAG_SEGMENTS_METRIC.getName(), new GaugeWrapper(RemoteStorageMetrics.REMOTE_DELETE_LAG_SEGMENTS_METRIC.getName()));
            this.metricGaugeTypeMap.put(RemoteStorageMetrics.REMOTE_LOG_METADATA_COUNT_METRIC.getName(), new GaugeWrapper(RemoteStorageMetrics.REMOTE_LOG_METADATA_COUNT_METRIC.getName()));
            this.metricGaugeTypeMap.put(RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName(), new GaugeWrapper(RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName()));
            this.metricGaugeTypeMap.put(RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName(), new GaugeWrapper(RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName()));
        }
    }

    public void closeMetric(String metricName) {
        GaugeWrapper mg;
        MeterWrapper mw = this.metricTypeMap.get(metricName);
        if (mw != null) {
            mw.close();
        }
        if ((mg = this.metricGaugeTypeMap.get(metricName)) != null) {
            mg.close();
        }
    }

    public void close() {
        this.metricTypeMap.values().forEach(MeterWrapper::close);
        this.metricGaugeTypeMap.values().forEach(GaugeWrapper::close);
    }

    public Set<String> metricMapKeySet() {
        return this.metricTypeMap.keySet();
    }

    public Map<String, GaugeWrapper> metricGaugeMap() {
        return this.metricGaugeTypeMap;
    }

    public Meter messagesInRate() {
        return this.metricTypeMap.get(MESSAGE_IN_PER_SEC).meter();
    }

    public Meter bytesInRate() {
        return this.metricTypeMap.get(BYTES_IN_PER_SEC).meter();
    }

    public Meter bytesOutRate() {
        return this.metricTypeMap.get(BYTES_OUT_PER_SEC).meter();
    }

    public Meter bytesRejectedRate() {
        return this.metricTypeMap.get(BYTES_REJECTED_PER_SEC).meter();
    }

    public Optional<Meter> replicationBytesInRate() {
        if (this.tags.isEmpty()) {
            return Optional.of(this.metricTypeMap.get(REPLICATION_BYTES_IN_PER_SEC).meter());
        }
        return Optional.empty();
    }

    public Optional<Meter> replicationBytesOutRate() {
        if (this.tags.isEmpty()) {
            return Optional.of(this.metricTypeMap.get(REPLICATION_BYTES_OUT_PER_SEC).meter());
        }
        return Optional.empty();
    }

    public Optional<Meter> reassignmentBytesInPerSec() {
        if (this.tags.isEmpty()) {
            return Optional.of(this.metricTypeMap.get(REASSIGNMENT_BYTES_IN_PER_SEC).meter());
        }
        return Optional.empty();
    }

    public Optional<Meter> reassignmentBytesOutPerSec() {
        if (this.tags.isEmpty()) {
            return Optional.of(this.metricTypeMap.get(REASSIGNMENT_BYTES_OUT_PER_SEC).meter());
        }
        return Optional.empty();
    }

    public Meter failedProduceRequestRate() {
        return this.metricTypeMap.get(FAILED_PRODUCE_REQUESTS_PER_SEC).meter();
    }

    public Meter failedFetchRequestRate() {
        return this.metricTypeMap.get(FAILED_FETCH_REQUESTS_PER_SEC).meter();
    }

    public Meter totalProduceRequestRate() {
        return this.metricTypeMap.get(TOTAL_PRODUCE_REQUESTS_PER_SEC).meter();
    }

    public Meter totalFetchRequestRate() {
        return this.metricTypeMap.get(TOTAL_FETCH_REQUESTS_PER_SEC).meter();
    }

    public Meter fetchMessageConversionsRate() {
        return this.metricTypeMap.get(FETCH_MESSAGE_CONVERSIONS_PER_SEC).meter();
    }

    public Meter produceMessageConversionsRate() {
        return this.metricTypeMap.get(PRODUCE_MESSAGE_CONVERSIONS_PER_SEC).meter();
    }

    public Meter noKeyCompactedTopicRecordsPerSec() {
        return this.metricTypeMap.get(NO_KEY_COMPACTED_TOPIC_RECORDS_PER_SEC).meter();
    }

    public Meter invalidMagicNumberRecordsPerSec() {
        return this.metricTypeMap.get(INVALID_MAGIC_NUMBER_RECORDS_PER_SEC).meter();
    }

    public Meter invalidMessageCrcRecordsPerSec() {
        return this.metricTypeMap.get(INVALID_MESSAGE_CRC_RECORDS_PER_SEC).meter();
    }

    public Meter invalidOffsetOrSequenceRecordsPerSec() {
        return this.metricTypeMap.get(INVALID_OFFSET_OR_SEQUENCE_RECORDS_PER_SEC).meter();
    }

    public GaugeWrapper remoteCopyLagBytesAggrMetric() {
        return this.metricGaugeTypeMap.get(RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName());
    }

    public long remoteCopyLagBytes() {
        return this.remoteCopyLagBytesAggrMetric().value();
    }

    public GaugeWrapper remoteCopyLagSegmentsAggrMetric() {
        return this.metricGaugeTypeMap.get(RemoteStorageMetrics.REMOTE_COPY_LAG_SEGMENTS_METRIC.getName());
    }

    public long remoteCopyLagSegments() {
        return this.remoteCopyLagSegmentsAggrMetric().value();
    }

    public GaugeWrapper remoteLogMetadataCountAggrMetric() {
        return this.metricGaugeTypeMap.get(RemoteStorageMetrics.REMOTE_LOG_METADATA_COUNT_METRIC.getName());
    }

    public long remoteLogMetadataCount() {
        return this.remoteLogMetadataCountAggrMetric().value();
    }

    public GaugeWrapper remoteLogSizeBytesAggrMetric() {
        return this.metricGaugeTypeMap.get(RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName());
    }

    public long remoteLogSizeBytes() {
        return this.remoteLogSizeBytesAggrMetric().value();
    }

    public GaugeWrapper remoteLogSizeComputationTimeAggrMetric() {
        return this.metricGaugeTypeMap.get(RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName());
    }

    public long remoteLogSizeComputationTime() {
        return this.remoteLogSizeComputationTimeAggrMetric().value();
    }

    public GaugeWrapper remoteDeleteLagBytesAggrMetric() {
        return this.metricGaugeTypeMap.get(RemoteStorageMetrics.REMOTE_DELETE_LAG_BYTES_METRIC.getName());
    }

    public long remoteDeleteLagBytes() {
        return this.remoteDeleteLagBytesAggrMetric().value();
    }

    public GaugeWrapper remoteDeleteLagSegmentsAggrMetric() {
        return this.metricGaugeTypeMap.get(RemoteStorageMetrics.REMOTE_DELETE_LAG_SEGMENTS_METRIC.getName());
    }

    public long remoteDeleteLagSegments() {
        return this.remoteDeleteLagSegmentsAggrMetric().value();
    }

    public Meter remoteCopyBytesRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.REMOTE_COPY_BYTES_PER_SEC_METRIC.getName()).meter();
    }

    public Meter remoteFetchBytesRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.REMOTE_FETCH_BYTES_PER_SEC_METRIC.getName()).meter();
    }

    public Meter remoteFetchRequestRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.REMOTE_FETCH_REQUESTS_PER_SEC_METRIC.getName()).meter();
    }

    public Meter remoteCopyRequestRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.REMOTE_COPY_REQUESTS_PER_SEC_METRIC.getName()).meter();
    }

    public Meter remoteDeleteRequestRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.REMOTE_DELETE_REQUESTS_PER_SEC_METRIC.getName()).meter();
    }

    public Meter buildRemoteLogAuxStateRequestRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.BUILD_REMOTE_LOG_AUX_STATE_REQUESTS_PER_SEC_METRIC.getName()).meter();
    }

    public Meter failedRemoteFetchRequestRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.FAILED_REMOTE_FETCH_PER_SEC_METRIC.getName()).meter();
    }

    public Meter failedRemoteCopyRequestRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.FAILED_REMOTE_COPY_PER_SEC_METRIC.getName()).meter();
    }

    public Meter failedRemoteDeleteRequestRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.FAILED_REMOTE_DELETE_PER_SEC_METRIC.getName()).meter();
    }

    public Meter failedBuildRemoteLogAuxStateRate() {
        return this.metricTypeMap.get(RemoteStorageMetrics.FAILED_BUILD_REMOTE_LOG_AUX_STATE_PER_SEC_METRIC.getName()).meter();
    }

    public class GaugeWrapper {
        private final ConcurrentHashMap<String, Long> metricValues = new ConcurrentHashMap();
        private final String metricType;

        public GaugeWrapper(String metricType) {
            this.metricType = metricType;
            this.newGaugeIfNeed();
        }

        public void setValue(String key, long value) {
            this.newGaugeIfNeed();
            this.metricValues.put(key, value);
        }

        public void removeKey(String key) {
            this.newGaugeIfNeed();
            this.metricValues.remove(key);
        }

        public void close() {
            BrokerTopicMetrics.this.metricsGroup.removeMetric(this.metricType, BrokerTopicMetrics.this.tags);
            this.metricValues.clear();
        }

        public long value() {
            return this.metricValues.values().stream().mapToLong(v -> v).sum();
        }

        private void newGaugeIfNeed() {
            BrokerTopicMetrics.this.metricsGroup.newGauge(this.metricType, () -> this.metricValues.values().stream().mapToLong(v -> v).sum(), BrokerTopicMetrics.this.tags);
        }
    }

    private class MeterWrapper {
        private final String metricType;
        private final String eventType;
        private volatile Meter lazyMeter;
        private final Lock meterLock = new ReentrantLock();

        public MeterWrapper(String metricType, String eventType) {
            this.metricType = metricType;
            this.eventType = eventType;
            if (BrokerTopicMetrics.this.tags.isEmpty()) {
                this.meter();
            }
        }

        public Meter meter() {
            Meter meter = this.lazyMeter;
            if (meter == null) {
                this.meterLock.lock();
                try {
                    meter = this.lazyMeter;
                    if (meter == null) {
                        this.lazyMeter = meter = BrokerTopicMetrics.this.metricsGroup.newMeter(this.metricType, this.eventType, TimeUnit.SECONDS, BrokerTopicMetrics.this.tags);
                    }
                }
                finally {
                    this.meterLock.unlock();
                }
            }
            return meter;
        }

        public void close() {
            this.meterLock.lock();
            try {
                if (this.lazyMeter != null) {
                    BrokerTopicMetrics.this.metricsGroup.removeMetric(this.metricType, BrokerTopicMetrics.this.tags);
                    this.lazyMeter = null;
                }
            }
            finally {
                this.meterLock.unlock();
            }
        }
    }
}

