/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.internals.UpgradeFromValues;
import org.apache.kafka.streams.kstream.internals.WrappingNullableDeserializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerde;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerializer;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapper;
import org.apache.kafka.streams.processor.internals.SerdeGetter;

public class SubscriptionWrapperSerde<KLeft>
extends WrappingNullableSerde<SubscriptionWrapper<KLeft>, KLeft, Void> {
    public SubscriptionWrapperSerde(Supplier<String> primaryKeySerializationPseudoTopicSupplier, Serde<KLeft> primaryKeySerde) {
        super(new SubscriptionWrapperSerializer(primaryKeySerializationPseudoTopicSupplier, primaryKeySerde == null ? null : primaryKeySerde.serializer()), new SubscriptionWrapperDeserializer(primaryKeySerializationPseudoTopicSupplier, primaryKeySerde == null ? null : primaryKeySerde.deserializer()));
    }

    private static class SubscriptionWrapperSerializer<KLeft>
    implements Serializer<SubscriptionWrapper<KLeft>>,
    WrappingNullableSerializer<SubscriptionWrapper<KLeft>, KLeft, Void> {
        private final Supplier<String> primaryKeySerializationPseudoTopicSupplier;
        private String primaryKeySerializationPseudoTopic = null;
        private Serializer<KLeft> primaryKeySerializer;
        private boolean upgradeFromV0 = false;

        SubscriptionWrapperSerializer(Supplier<String> primaryKeySerializationPseudoTopicSupplier, Serializer<KLeft> primaryKeySerializer) {
            this.primaryKeySerializationPseudoTopicSupplier = primaryKeySerializationPseudoTopicSupplier;
            this.primaryKeySerializer = primaryKeySerializer;
        }

        @Override
        public void setIfUnset(SerdeGetter getter) {
            if (this.primaryKeySerializer == null) {
                this.primaryKeySerializer = getter.keySerde().serializer();
            }
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.upgradeFromV0 = SubscriptionWrapperSerializer.upgradeFromV0(configs);
        }

        private static boolean upgradeFromV0(Map<String, ?> configs) {
            Object upgradeFrom = configs.get("upgrade.from");
            if (upgradeFrom == null) {
                return false;
            }
            switch (UpgradeFromValues.fromString((String)upgradeFrom)) {
                case UPGRADE_FROM_0100: 
                case UPGRADE_FROM_0101: 
                case UPGRADE_FROM_0102: 
                case UPGRADE_FROM_0110: 
                case UPGRADE_FROM_10: 
                case UPGRADE_FROM_11: 
                case UPGRADE_FROM_20: 
                case UPGRADE_FROM_21: 
                case UPGRADE_FROM_22: 
                case UPGRADE_FROM_23: 
                case UPGRADE_FROM_24: 
                case UPGRADE_FROM_25: 
                case UPGRADE_FROM_26: 
                case UPGRADE_FROM_27: 
                case UPGRADE_FROM_28: 
                case UPGRADE_FROM_30: 
                case UPGRADE_FROM_31: 
                case UPGRADE_FROM_32: 
                case UPGRADE_FROM_33: {
                    return true;
                }
            }
            return false;
        }

        public byte[] serialize(String ignored, SubscriptionWrapper<KLeft> data) {
            if (data.version() < 0) {
                throw new UnsupportedVersionException("SubscriptionWrapper version cannot be negative");
            }
            byte version = data.version();
            if (this.upgradeFromV0 || version == 0) {
                return this.serializeV0(data);
            }
            if (version == 1) {
                return this.serializeV1(data);
            }
            throw new UnsupportedVersionException("Unsupported SubscriptionWrapper version " + data.version());
        }

        private byte[] serializePrimaryKey(SubscriptionWrapper<KLeft> data) {
            if (this.primaryKeySerializationPseudoTopic == null) {
                this.primaryKeySerializationPseudoTopic = this.primaryKeySerializationPseudoTopicSupplier.get();
            }
            return this.primaryKeySerializer.serialize(this.primaryKeySerializationPseudoTopic, data.primaryKey());
        }

        private ByteBuffer serializeCommon(SubscriptionWrapper<KLeft> data, byte version, int extraLength) {
            ByteBuffer buf;
            byte[] primaryKeySerializedData = this.serializePrimaryKey(data);
            int dataLength = 2 + primaryKeySerializedData.length + extraLength;
            if (data.hash() != null) {
                buf = ByteBuffer.allocate(dataLength += 16);
                buf.put(version);
            } else {
                buf = ByteBuffer.allocate(dataLength);
                buf.put((byte)(version | 0xFFFFFF80));
            }
            buf.put(data.instruction().value());
            long[] elem = data.hash();
            if (data.hash() != null) {
                buf.putLong(elem[0]);
                buf.putLong(elem[1]);
            }
            buf.put(primaryKeySerializedData);
            return buf;
        }

        private byte[] serializeV0(SubscriptionWrapper<KLeft> data) {
            return this.serializeCommon(data, (byte)0, 0).array();
        }

        private byte[] serializeV1(SubscriptionWrapper<KLeft> data) {
            ByteBuffer buf = this.serializeCommon(data, data.version(), 4);
            buf.putInt(data.primaryPartition());
            return buf.array();
        }
    }

    private static class SubscriptionWrapperDeserializer<KLeft>
    implements Deserializer<SubscriptionWrapper<KLeft>>,
    WrappingNullableDeserializer<SubscriptionWrapper<KLeft>, KLeft, Void> {
        private final Supplier<String> primaryKeySerializationPseudoTopicSupplier;
        private String primaryKeySerializationPseudoTopic = null;
        private Deserializer<KLeft> primaryKeyDeserializer;

        SubscriptionWrapperDeserializer(Supplier<String> primaryKeySerializationPseudoTopicSupplier, Deserializer<KLeft> primaryKeyDeserializer) {
            this.primaryKeySerializationPseudoTopicSupplier = primaryKeySerializationPseudoTopicSupplier;
            this.primaryKeyDeserializer = primaryKeyDeserializer;
        }

        @Override
        public void setIfUnset(SerdeGetter getter) {
            if (this.primaryKeyDeserializer == null) {
                this.primaryKeyDeserializer = getter.keySerde().deserializer();
            }
        }

        public SubscriptionWrapper<KLeft> deserialize(String ignored, byte[] data) {
            long[] hash;
            ByteBuffer buf = ByteBuffer.wrap(data);
            byte versionAndIsHashNull = buf.get();
            byte version = (byte)(0x7F & versionAndIsHashNull);
            boolean isHashNull = (0x80 & versionAndIsHashNull) == 128;
            SubscriptionWrapper.Instruction inst = SubscriptionWrapper.Instruction.fromValue(buf.get());
            int lengthSum = 2;
            if (isHashNull) {
                hash = null;
            } else {
                hash = new long[]{buf.getLong(), buf.getLong()};
                lengthSum += 16;
            }
            int primaryKeyLength = version > 0 ? data.length - lengthSum - 4 : data.length - lengthSum;
            byte[] primaryKeyRaw = new byte[primaryKeyLength];
            buf.get(primaryKeyRaw, 0, primaryKeyLength);
            if (this.primaryKeySerializationPseudoTopic == null) {
                this.primaryKeySerializationPseudoTopic = this.primaryKeySerializationPseudoTopicSupplier.get();
            }
            Object primaryKey = this.primaryKeyDeserializer.deserialize(this.primaryKeySerializationPseudoTopic, primaryKeyRaw);
            Integer primaryPartition = version > 0 ? Integer.valueOf(buf.getInt()) : null;
            return new SubscriptionWrapper<Object>(hash, inst, primaryKey, version, primaryPartition);
        }
    }
}

