/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.karaf.log.core;

import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

import java.util.Map;

public interface LogService {

    String getLevel();
    void setLevel(String level);

    Map<String, String> getLevel(String logger);
    void setLevel(String logger, String level);
    
    void clearEvents();
    Iterable<PaxLoggingEvent> getEvents();
    Iterable<PaxLoggingEvent> getEvents(int maxNum);
    PaxLoggingEvent getLastException(String logger);
    void addAppender(PaxAppender appender);
    void removeAppender(PaxAppender appender);
}
