/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.support.builder.ExpressionBuilder;

public class StringAggregationStrategy
implements AggregationStrategy {
    private String delimiter = "";
    private Expression pickExpression = ExpressionBuilder.bodyExpression();

    public StringAggregationStrategy delimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public StringAggregationStrategy pick(Expression expression) {
        this.pickExpression = expression;
        return this;
    }

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        String pick;
        StringBuffer result;
        StringBuilder value = new StringBuilder();
        if (oldExchange == null) {
            result = StringAggregationStrategy.getStringBuffer(newExchange);
        } else {
            result = StringAggregationStrategy.getStringBuffer(oldExchange);
            value.append(this.delimiter);
        }
        if (newExchange != null && (pick = (String)this.pickExpression.evaluate(newExchange, String.class)) != null) {
            value.append(pick);
            result.append((CharSequence)value);
        }
        return oldExchange != null ? oldExchange : newExchange;
    }

    public void onCompletion(Exchange exchange) {
        StringBuffer stringBuffer;
        if (exchange != null && (stringBuffer = (StringBuffer)exchange.removeProperty("CamelGroupedExchange")) != null) {
            exchange.getIn().setBody((Object)stringBuffer.toString());
        }
    }

    private static StringBuffer getStringBuffer(Exchange exchange) {
        StringBuffer stringBuffer = (StringBuffer)exchange.getProperty("CamelGroupedExchange", StringBuffer.class);
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
            exchange.setProperty("CamelGroupedExchange", (Object)stringBuffer);
        }
        return stringBuffer;
    }
}

