/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import org.apache.camel.impl.engine.DefaultFactoryFinder;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OsgiFactoryFinder
extends DefaultFactoryFinder {
    private BundleContext bundleContext;

    public OsgiFactoryFinder(BundleContext bundleContext, ClassResolver classResolver, String resourcePath) {
        super(classResolver, resourcePath);
        this.bundleContext = bundleContext;
    }

    public Optional<Class<?>> findClass(String key) {
        String classKey = key;
        Class answer = this.addToClassMap(classKey, () -> {
            BundleEntry entry = this.getResource(key);
            if (entry != null) {
                URL url = entry.url;
                InputStream in = url.openStream();
                BufferedInputStream reader = null;
                try {
                    reader = IOHelper.buffered((InputStream)in);
                    Properties properties = new Properties();
                    properties.load(reader);
                    String className = properties.getProperty("class");
                    if (className == null) {
                        throw new IOException("Expected property is missing: class");
                    }
                    Class clazz = entry.bundle.loadClass(className);
                    return clazz;
                }
                finally {
                    IOHelper.close((Closeable)reader, (String)key, null);
                    IOHelper.close((Closeable)in, (String)key, null);
                }
            }
            return null;
        });
        return Optional.ofNullable(answer);
    }

    public BundleEntry getResource(String name) {
        Bundle[] bundles;
        BundleEntry entry = null;
        for (Bundle bundle : bundles = this.bundleContext.getBundles()) {
            URL url = bundle.getEntry(this.getResourcePath() + name);
            if (url == null) continue;
            entry = new BundleEntry();
            entry.url = url;
            entry.bundle = bundle;
            break;
        }
        return entry;
    }

    private static class BundleEntry {
        URL url;
        Bundle bundle;

        private BundleEntry() {
        }
    }
}

