/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.io.DefaultIoConnectFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactory;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.core.CoreModuleProperties;

public class Nio2Connector
extends Nio2Service
implements IoConnector {
    private final Nio2ServiceFactory nio2ServiceFactory;

    public Nio2Connector(Nio2ServiceFactory nio2ServiceFactory, PropertyResolver propertyResolver, IoHandler handler, AsynchronousChannelGroup group, ExecutorService resumeTasks) {
        super(propertyResolver, handler, group, resumeTasks);
        this.nio2ServiceFactory = nio2ServiceFactory;
    }

    @Override
    public IoConnectFuture connect(SocketAddress address, AttributeRepository context, SocketAddress localAddress) {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("Connecting to {}", (Object)address);
        }
        DefaultIoConnectFuture future = new DefaultIoConnectFuture(address, null);
        AsynchronousSocketChannel channel = null;
        AsynchronousSocketChannel socket = null;
        try {
            AsynchronousChannelGroup group = this.getChannelGroup();
            channel = this.openAsynchronousSocketChannel(address, group);
            socket = this.setSocketOptions(channel);
            if (localAddress != null) {
                socket.bind(localAddress);
            }
            Nio2CompletionHandler<Void, Object> completionHandler = ValidateUtils.checkNotNull(this.createConnectionCompletionHandler(future, socket, context, this.propertyResolver, this.getIoHandler()), "No connection completion handler created for %s", (Object)address);
            Future<Void> cf = socket.connect(address);
            Long connectTimeout = CoreModuleProperties.IO_CONNECT_TIMEOUT.get(this.propertyResolver).map(d -> {
                long millis;
                if (d.isZero() || d.isNegative()) {
                    return null;
                }
                try {
                    millis = d.toMillis();
                }
                catch (ArithmeticException e) {
                    millis = Long.MAX_VALUE;
                }
                return millis;
            }).orElse(null);
            Future<?> rf = this.getExecutorService().submit(() -> {
                try {
                    if (connectTimeout != null) {
                        this.log.debug("connect({}): waiting for connection (timeout={}ms)", (Object)address, (Object)connectTimeout);
                        cf.get(connectTimeout, TimeUnit.MILLISECONDS);
                    } else {
                        this.log.debug("connect({}): waiting for connection", (Object)address);
                        cf.get();
                    }
                    completionHandler.onCompleted(null, null);
                }
                catch (CancellationException e) {
                    CancelFuture cancellation = future.cancel();
                    if (cancellation != null) {
                        cancellation.setCanceled(e);
                    }
                }
                catch (TimeoutException e) {
                    cf.cancel(true);
                    ConnectException c = new ConnectException("I/O connection time-out of " + connectTimeout + "ms expired");
                    c.initCause(e);
                    completionHandler.onFailed(c, null);
                }
                catch (ExecutionException e) {
                    completionHandler.onFailed(e, null);
                }
                catch (InterruptedException e) {
                    completionHandler.onFailed(e, null);
                    Thread.currentThread().interrupt();
                }
            });
            future.addListener(f -> {
                if (f.isCanceled()) {
                    rf.cancel(false);
                    cf.cancel(true);
                }
            });
        }
        catch (Throwable exc) {
            Throwable t;
            block11: {
                block10: {
                    t = ExceptionUtils.peelException(exc);
                    this.debug("connect({}) failed ({}) to schedule connection: {}", address, t.getClass().getSimpleName(), t.getMessage(), t);
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException err) {
                        if (!debugEnabled) break block10;
                        this.log.debug("connect({}) - failed ({}) to close socket: {}", new Object[]{address, err.getClass().getSimpleName(), err.getMessage()});
                    }
                }
                try {
                    if (channel != null) {
                        channel.close();
                    }
                }
                catch (IOException err) {
                    if (!debugEnabled) break block11;
                    this.log.debug("connect({}) - failed ({}) to close channel: {}", new Object[]{address, err.getClass().getSimpleName(), err.getMessage()});
                }
            }
            future.setException(t);
        }
        return future;
    }

    protected AsynchronousSocketChannel openAsynchronousSocketChannel(SocketAddress address, AsynchronousChannelGroup group) throws IOException {
        return AsynchronousSocketChannel.open(group);
    }

    protected Nio2CompletionHandler<Void, Object> createConnectionCompletionHandler(IoConnectFuture future, AsynchronousSocketChannel socket, AttributeRepository context, PropertyResolver propertyResolver, IoHandler handler) {
        return new ConnectionCompletionHandler(future, socket, context, propertyResolver, handler);
    }

    protected Nio2Session createSession(PropertyResolver propertyResolver, IoHandler handler, AsynchronousSocketChannel socket) throws Throwable {
        return this.nio2ServiceFactory.createSession(this, handler, socket, null);
    }

    protected class ConnectionCompletionHandler
    extends Nio2CompletionHandler<Void, Object> {
        protected final IoConnectFuture future;
        protected final AsynchronousSocketChannel socket;
        protected final AttributeRepository context;
        protected final PropertyResolver propertyResolver;
        protected final IoHandler handler;

        protected ConnectionCompletionHandler(IoConnectFuture future, AsynchronousSocketChannel socket, AttributeRepository context, PropertyResolver propertyResolver, IoHandler handler) {
            this.future = future;
            this.socket = socket;
            this.context = context;
            this.propertyResolver = propertyResolver;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCompleted(Void result, Object attachment) {
            block19: {
                Long sessionId = null;
                IoServiceEventListener listener = Nio2Connector.this.getIoServiceEventListener();
                try {
                    if (listener != null) {
                        SocketAddress local = this.socket.getLocalAddress();
                        SocketAddress remote = this.socket.getRemoteAddress();
                        listener.connectionEstablished(Nio2Connector.this, local, this.context, remote);
                    }
                    Nio2Session session = Nio2Connector.this.createSession(this.propertyResolver, this.handler, this.socket);
                    if (this.context != null) {
                        session.setAttribute(AttributeRepository.class, this.context);
                    }
                    this.handler.sessionCreated(session);
                    sessionId = session.getId();
                    Nio2Connector.this.sessions.put(sessionId, session);
                    this.future.setSession(session);
                    if (session != this.future.getSession()) {
                        session.close(true);
                        throw new CancellationException();
                    }
                    if (session.isClosing()) {
                        try {
                            this.handler.sessionClosed(session);
                            break block19;
                        }
                        finally {
                            Nio2Connector.this.unmapSession(sessionId);
                        }
                    }
                    session.startReading();
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Throwable exc) {
                    Throwable t;
                    block21: {
                        boolean debugEnabled;
                        block20: {
                            t = ExceptionUtils.peelException(exc);
                            debugEnabled = Nio2Connector.this.log.isDebugEnabled();
                            if (listener != null) {
                                try {
                                    SocketAddress localAddress = this.socket.getLocalAddress();
                                    SocketAddress remoteAddress = this.socket.getRemoteAddress();
                                    listener.abortEstablishedConnection(Nio2Connector.this, localAddress, this.context, remoteAddress, t);
                                }
                                catch (Exception e) {
                                    if (!debugEnabled) break block20;
                                    Nio2Connector.this.log.debug("onCompleted() listener=" + listener + " ignoring abort event exception", (Throwable)e);
                                }
                            }
                        }
                        Nio2Connector.this.log.debug("onCompleted - failed to start session: {} {}", new Object[]{t.getClass().getSimpleName(), t.getMessage(), t});
                        IoSession session = this.future.getSession();
                        if (session != null) {
                            try {
                                session.close(true);
                            }
                            finally {
                                this.future.setException(t);
                            }
                        }
                        try {
                            this.socket.close();
                        }
                        catch (IOException err) {
                            if (!debugEnabled) break block21;
                            Nio2Connector.this.log.debug("onCompleted - failed to close socket: {} {}", (Object)err.getClass().getSimpleName(), (Object)err.getMessage());
                        }
                    }
                    this.future.setException(t);
                    Nio2Connector.this.unmapSession(sessionId);
                }
            }
        }

        @Override
        protected void onFailed(Throwable exc, Object attachment) {
            this.future.setException(exc);
        }
    }
}

