/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.endTransaction;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.message.Control;

public class UpdateControls {
    private int messageId;
    private List<Control> controls = new ArrayList<Control>();

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public List<Control> getControls() {
        return this.controls;
    }

    public void setControls(List<Control> controls) {
        this.controls = controls;
    }

    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + this.messageId;
        for (Control control : this.controls) {
            hash = hash * 17 + control.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateControls)) {
            return false;
        }
        UpdateControls that = (UpdateControls)obj;
        if (this.messageId != that.getMessageId()) {
            return false;
        }
        if (this.controls.size() != that.getControls().size()) {
            return false;
        }
        for (Control control : this.controls) {
            if (that.getControls().contains(control)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateControl :");
        sb.append("\n    messageId : ").append(this.messageId);
        if (this.controls.isEmpty()) {
            sb.append("\n    No controls");
        } else {
            sb.append("\n    Controls: [");
            boolean isFirst = true;
            for (Control control : this.controls) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(control.getOid());
            }
            sb.append(']');
        }
        return sb.toString();
    }
}

