/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.Param;

public class Provider {
    private static final GatewaySpiMessages LOG = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);
    private String role;
    private String name;
    private boolean enabled;
    private Map<String, String> params = new LinkedHashMap<String, String>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public void addParam(Param param) {
        if (this.params.containsKey(param.getName())) {
            LOG.duplicatedFilterParamKey(param.getName());
        }
        this.params.put(param.getName(), param.getValue());
    }

    public Collection<Param> getParamsList() {
        ArrayList<Param> paramList = new ArrayList<Param>();
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            Param p = new Param();
            p.setName(entry.getKey());
            p.setValue(entry.getValue());
            paramList.add(p);
        }
        return paramList;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append((Object)this.role).append(this.params).append(this.enabled).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Provider)) {
            return false;
        }
        Provider other = (Provider)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)other.name).append((Object)this.role, (Object)other.role).append(this.params, other.params).append(this.enabled, other.enabled).build();
    }
}

