/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.knoxsso;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.audit.log4j.audit.Log4jAuditor;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.knoxsso.KnoxSSOMessages;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.token.JWTokenAttributes;
import org.apache.knox.gateway.services.security.token.JWTokenAttributesBuilder;
import org.apache.knox.gateway.services.security.token.JWTokenAuthority;
import org.apache.knox.gateway.services.security.token.TokenMetadata;
import org.apache.knox.gateway.services.security.token.TokenServiceException;
import org.apache.knox.gateway.services.security.token.TokenStateService;
import org.apache.knox.gateway.services.security.token.TokenUtils;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.session.control.ConcurrentSessionVerifier;
import org.apache.knox.gateway.util.CookieUtils;
import org.apache.knox.gateway.util.RegExUtils;
import org.apache.knox.gateway.util.SetCookieHeader;
import org.apache.knox.gateway.util.Tokens;
import org.apache.knox.gateway.util.Urls;
import org.apache.knox.gateway.util.WhitelistUtils;

@Path(value="/api/v1/websso")
public class WebSSOResource {
    private static final KnoxSSOMessages LOGGER = (KnoxSSOMessages)MessagesFactory.get(KnoxSSOMessages.class);
    private static final String SSO_COOKIE_NAME = "knoxsso.cookie.name";
    private static final String SSO_COOKIE_SECURE_ONLY_INIT_PARAM = "knoxsso.cookie.secure.only";
    private static final String SSO_COOKIE_MAX_AGE_INIT_PARAM = "knoxsso.cookie.max.age";
    private static final String SSO_COOKIE_DOMAIN_SUFFIX_PARAM = "knoxsso.cookie.domain.suffix";
    private static final String SSO_COOKIE_SAMESITE_PARAM = "knoxsso.cookie.samesite";
    private static final String SSO_COOKIE_TOKEN_TTL_PARAM = "knoxsso.token.ttl";
    private static final String SSO_COOKIE_TOKEN_AUDIENCES_PARAM = "knoxsso.token.audiences";
    private static final String SSO_COOKIE_TOKEN_SIG_ALG = "knoxsso.token.sigalg";
    private static final String SSO_COOKIE_TOKEN_WHITELIST_PARAM = "knoxsso.redirect.whitelist.regex";
    private static final String SSO_SIGNINGKEY_KEYSTORE_NAME = "knoxsso.signingkey.keystore.name";
    private static final String SSO_SIGNINGKEY_KEYSTORE_ALIAS = "knoxsso.signingkey.keystore.alias";
    private static final String SSO_SIGNINGKEY_KEYSTORE_PASSPHRASE_ALIAS = "knoxsso.signingkey.keystore.passphrase.alias";
    private static final String SSO_TOKEN_ISSUER = "knoxsso.token.issuer";
    private static final String SSO_EXPECTED_PARAM = "knoxsso.expected.params";
    private static final String SSO_ENABLE_SESSION_PARAM = "knoxsso.enable.session";
    private static final String ORIGINAL_URL_REQUEST_PARAM = "originalUrl";
    private static final String ORIGINAL_URL_COOKIE_NAME = "original-url";
    private static final String DEFAULT_SSO_COOKIE_NAME = "hadoop-jwt";
    private static final String SSO_COOKIE_SAMESITE_DEFAULT = "Strict";
    public static final long TOKEN_TTL_DEFAULT = 900000L;
    static final String RESOURCE_PATH = "/api/v1/websso";
    private String cookieName;
    private boolean secureOnly = true;
    private int maxAge = -1;
    private long tokenTTL = 900000L;
    private String whitelist;
    private String domainSuffix;
    private List<String> targetAudiences = new ArrayList<String>();
    private boolean enableSession;
    private String signatureAlgorithm;
    private List<String> ssoExpectedparams = new ArrayList<String>();
    private String clusterName;
    private String tokenIssuer;
    private TokenStateService tokenStateService;
    private String sameSiteValue;
    @Context
    HttpServletRequest request;
    @Context
    HttpServletResponse response;
    @Context
    ServletContext context;

    @PostConstruct
    public void init() throws AliasServiceException {
        this.clusterName = String.valueOf(this.context.getAttribute("org.apache.knox.gateway.gateway.cluster"));
        this.handleCookieSetup();
        String enableSessionStr = this.context.getInitParameter(SSO_ENABLE_SESSION_PARAM);
        this.enableSession = Boolean.parseBoolean(enableSessionStr);
        this.tokenIssuer = StringUtils.isBlank((CharSequence)this.context.getInitParameter(SSO_TOKEN_ISSUER)) ? "KNOXSSO" : this.context.getInitParameter(SSO_TOKEN_ISSUER);
        this.setSignatureAlogrithm();
        String expectedParams = this.context.getInitParameter(SSO_EXPECTED_PARAM);
        if (expectedParams != null) {
            this.ssoExpectedparams = Arrays.asList(expectedParams.split(","));
        }
        this.sameSiteValue = StringUtils.isBlank((CharSequence)this.context.getInitParameter(SSO_COOKIE_SAMESITE_PARAM)) ? SSO_COOKIE_SAMESITE_DEFAULT : this.context.getInitParameter(SSO_COOKIE_SAMESITE_PARAM);
        GatewayServices services = (GatewayServices)this.context.getAttribute("org.apache.knox.gateway.gateway.services");
        if (services != null && TokenUtils.isServerManagedTokenStateEnabled((ServletContext)this.context)) {
            this.tokenStateService = (TokenStateService)services.getService(ServiceType.TOKEN_STATE_SERVICE);
        }
    }

    private void setSignatureAlogrithm() throws AliasServiceException {
        String configuredSigAlg = this.context.getInitParameter(SSO_COOKIE_TOKEN_SIG_ALG);
        GatewayConfig config = (GatewayConfig)this.request.getServletContext().getAttribute("org.apache.knox.gateway.config");
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        this.signatureAlgorithm = TokenUtils.getSignatureAlgorithm((String)configuredSigAlg, (AliasService)((AliasService)services.getService(ServiceType.ALIAS_SERVICE)), (String)config.getSigningKeystoreName());
    }

    private void handleCookieSetup() {
        String ttl;
        String audiences;
        String age;
        String secure;
        this.cookieName = this.context.getInitParameter(SSO_COOKIE_NAME);
        if (this.cookieName == null) {
            this.cookieName = DEFAULT_SSO_COOKIE_NAME;
        }
        if (StringUtils.isBlank((CharSequence)(secure = this.context.getInitParameter(SSO_COOKIE_SECURE_ONLY_INIT_PARAM)))) {
            GatewayConfig config = (GatewayConfig)this.request.getServletContext().getAttribute("org.apache.knox.gateway.config");
            this.secureOnly = config.isSSLEnabled();
        } else {
            this.secureOnly = Boolean.parseBoolean(secure);
        }
        if (!this.secureOnly) {
            LOGGER.cookieSecureOnly(this.secureOnly);
        }
        if ((age = this.context.getInitParameter(SSO_COOKIE_MAX_AGE_INIT_PARAM)) != null) {
            try {
                LOGGER.setMaxAge(age);
                this.maxAge = Integer.parseInt(age);
            }
            catch (NumberFormatException nfe) {
                LOGGER.invalidMaxAgeEncountered(age);
            }
        }
        this.domainSuffix = this.context.getInitParameter(SSO_COOKIE_DOMAIN_SUFFIX_PARAM);
        this.whitelist = this.context.getInitParameter(SSO_COOKIE_TOKEN_WHITELIST_PARAM);
        if (this.whitelist == null) {
            this.whitelist = WhitelistUtils.getDispatchWhitelist((HttpServletRequest)this.request);
        }
        if ((audiences = this.context.getInitParameter(SSO_COOKIE_TOKEN_AUDIENCES_PARAM)) != null) {
            String[] auds;
            for (String aud : auds = audiences.split(",")) {
                this.targetAudiences.add(aud.trim());
            }
        }
        if ((ttl = this.context.getInitParameter(SSO_COOKIE_TOKEN_TTL_PARAM)) != null) {
            try {
                this.tokenTTL = Long.parseLong(ttl);
                if (this.tokenTTL < -1L || this.tokenTTL + System.currentTimeMillis() < 0L) {
                    LOGGER.invalidTokenTTLEncountered(ttl);
                    this.tokenTTL = 900000L;
                }
            }
            catch (NumberFormatException nfe) {
                LOGGER.invalidTokenTTLEncountered(ttl);
            }
        }
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response doGet() {
        return this.getAuthenticationToken(307);
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    public Response doPost() {
        return this.getAuthenticationToken(303);
    }

    private Response getAuthenticationToken(int statusCode) {
        String original;
        HttpSession session;
        if (!this.enableSession && (session = this.request.getSession(false)) != null) {
            session.invalidate();
        }
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        boolean removeOriginalUrlCookie = true;
        List originalUrlCookies = CookieUtils.getCookiesForName((HttpServletRequest)this.request, (String)ORIGINAL_URL_COOKIE_NAME);
        if (originalUrlCookies.isEmpty()) {
            removeOriginalUrlCookie = false;
            original = this.getOriginalUrlFromQueryParams();
            if (original.isEmpty()) {
                LOGGER.originalURLNotFound();
                throw new WebApplicationException("Original URL not found in the request.", Response.Status.BAD_REQUEST);
            }
            boolean validRedirect = true;
            if (this.whitelist != null) {
                try {
                    validRedirect = RegExUtils.checkBaseUrlAgainstWhitelist((String)this.whitelist, (String)original);
                }
                catch (MalformedURLException e) {
                    throw new WebApplicationException("Malformed original URL: " + original, Response.Status.BAD_REQUEST);
                }
            }
            if (!validRedirect) {
                LOGGER.whiteListMatchFail(Log4jAuditor.maskTokenFromURL((String)original), this.whitelist);
                throw new WebApplicationException("Original URL not valid according to the configured whitelist.", Response.Status.BAD_REQUEST);
            }
        } else {
            original = ((Cookie)originalUrlCookies.get(0)).getValue();
        }
        Principal p = this.request.getUserPrincipal();
        ConcurrentSessionVerifier verifier = (ConcurrentSessionVerifier)services.getService(ServiceType.CONCURRENT_SESSION_VERIFIER);
        if (!verifier.verifySessionForUser(p.getName())) {
            throw new WebApplicationException("Too many sessions for user: " + this.request.getUserPrincipal().getName(), Response.Status.FORBIDDEN);
        }
        AliasService as = (AliasService)services.getService(ServiceType.ALIAS_SERVICE);
        JWTokenAuthority tokenAuthority = (JWTokenAuthority)services.getService(ServiceType.TOKEN_SERVICE);
        try {
            JWTokenAttributes jwtAttributes;
            JWT token;
            String signingKeystoreName = this.context.getInitParameter(SSO_SIGNINGKEY_KEYSTORE_NAME);
            String signingKeystoreAlias = this.context.getInitParameter(SSO_SIGNINGKEY_KEYSTORE_ALIAS);
            String signingKeystorePassphraseAlias = this.context.getInitParameter(SSO_SIGNINGKEY_KEYSTORE_PASSPHRASE_ALIAS);
            char[] signingKeystorePassphrase = null;
            if (signingKeystorePassphraseAlias != null) {
                signingKeystorePassphrase = as.getPasswordFromAliasForCluster(this.clusterName, signingKeystorePassphraseAlias);
            }
            if ((token = tokenAuthority.issueToken(jwtAttributes = new JWTokenAttributesBuilder().setIssuer(this.tokenIssuer).setUserName(p.getName()).setAudiences(this.targetAudiences).setAlgorithm(this.signatureAlgorithm).setExpires(this.getExpiry()).setSigningKeystoreName(signingKeystoreName).setSigningKeystoreAlias(signingKeystoreAlias).setSigningKeystorePassphrase(signingKeystorePassphrase).setManaged(this.tokenStateService != null).build())) != null) {
                if (!verifier.registerToken(p.getName(), token)) {
                    throw new WebApplicationException("Too many sessions for user: " + this.request.getUserPrincipal().getName(), Response.Status.FORBIDDEN);
                }
                this.saveToken(token);
                this.addJWTHadoopCookie(original, token);
            }
            if (removeOriginalUrlCookie) {
                this.removeOriginalUrlCookie(this.response);
            }
            LOGGER.aboutToRedirectToOriginal(Log4jAuditor.maskTokenFromURL((String)original));
            this.response.setStatus(statusCode);
            this.response.setHeader("Location", original);
            try {
                this.response.getOutputStream().close();
            }
            catch (IOException e) {
                LOGGER.unableToCloseOutputStream(e.getMessage(), Arrays.toString(e.getStackTrace()));
            }
        }
        catch (AliasServiceException | TokenServiceException e) {
            LOGGER.unableToIssueToken((Exception)e);
        }
        URI location = null;
        try {
            location = new URI(original);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return Response.seeOther(location).entity((Object)("{ \"redirectTo\" : " + original + " }")).build();
    }

    protected String getOriginalUrlFromQueryParams() {
        String original = this.request.getParameter(ORIGINAL_URL_REQUEST_PARAM);
        StringBuilder buf = new StringBuilder(original);
        boolean first = true;
        Map params = this.request.getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            if (ORIGINAL_URL_REQUEST_PARAM.equals(entry.getKey()) || original.contains((String)entry.getKey() + "=") || this.ssoExpectedparams.contains(entry.getKey())) continue;
            if (first && buf.lastIndexOf("?") == -1) {
                buf.append('?');
                first = false;
            }
            buf.append('&').append((String)entry.getKey());
            String[] values = (String[])entry.getValue();
            if (values.length > 0 && values[0] != null) {
                buf.append('=');
            }
            for (int i = 0; i < values.length; ++i) {
                if (values[0] == null) continue;
                buf.append(values[i]);
                if (i >= values.length - 1) continue;
                buf.append('&').append((String)entry.getKey()).append('=');
            }
        }
        return buf.toString();
    }

    private long getExpiry() {
        long expiry = this.tokenTTL == -1L ? -1L : System.currentTimeMillis() + this.tokenTTL;
        return expiry;
    }

    private void addJWTHadoopCookie(String original, JWT token) {
        String logSafeToken = Tokens.getTokenDisplayText((String)token.toString());
        LOGGER.addingJWTCookie(logSafeToken);
        try {
            SetCookieHeader setCookieHeader = new SetCookieHeader(this.cookieName, token.toString());
            setCookieHeader.setPath("/");
            String domain = Urls.getDomainName((String)original, (String)this.domainSuffix);
            if (domain != null) {
                setCookieHeader.setDomain(domain);
            }
            setCookieHeader.setHttpOnly(true);
            if (this.secureOnly) {
                setCookieHeader.setSecure(true);
            }
            if (this.maxAge != -1) {
                setCookieHeader.setMaxAge(this.maxAge);
            }
            setCookieHeader.setSameSite(this.sameSiteValue);
            this.response.setHeader("Set-Cookie", setCookieHeader.toString());
            LOGGER.addedJWTCookie(logSafeToken);
        }
        catch (Exception e) {
            LOGGER.unableAddCookieToResponse(e.getMessage(), Arrays.toString(e.getStackTrace()));
            throw new WebApplicationException("Unable to add JWT cookie to response.");
        }
    }

    private void removeOriginalUrlCookie(HttpServletResponse response) {
        Cookie c = new Cookie(ORIGINAL_URL_COOKIE_NAME, null);
        c.setMaxAge(0);
        c.setPath(RESOURCE_PATH);
        response.addCookie(c);
    }

    private void saveToken(JWT token) {
        if (this.tokenStateService != null) {
            String tokenId = TokenUtils.getTokenId((JWT)token);
            long issueTime = System.currentTimeMillis();
            this.tokenStateService.addToken(tokenId, issueTime, token.getExpiresDate().getTime(), this.tokenStateService.getDefaultMaxLifetimeDuration());
            TokenMetadata tokenMetadata = new TokenMetadata(token.getSubject());
            tokenMetadata.markKnoxSsoCookie();
            tokenMetadata.useTokenNow();
            this.tokenStateService.addMetadata(tokenId, tokenMetadata);
            LOGGER.storedToken(this.getTopologyName(), Tokens.getTokenDisplayText((String)token.toString()), Tokens.getTokenIDDisplayText((String)tokenId));
        }
    }

    private String getTopologyName() {
        return (String)this.context.getAttribute("org.apache.knox.gateway.gateway.cluster");
    }
}

