/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHostCertInfo;
import com.cloudera.api.swagger.model.BaseApiSshCmdArguments;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Arguments to generate a Cloudera Manager Certificate Authority (CMCA).")
public class ApiGenerateCmcaArguments
extends BaseApiSshCmdArguments {
    @SerializedName(value="location")
    private String location = null;
    @SerializedName(value="customCA")
    private Boolean customCA = null;
    @SerializedName(value="interpretAsFilenames")
    private Boolean interpretAsFilenames = null;
    @SerializedName(value="cmHostCert")
    private String cmHostCert = null;
    @SerializedName(value="cmHostKey")
    private String cmHostKey = null;
    @SerializedName(value="caCert")
    private String caCert = null;
    @SerializedName(value="keystorePasswd")
    private String keystorePasswd = null;
    @SerializedName(value="truststorePasswd")
    private String truststorePasswd = null;
    @SerializedName(value="trustedCaCerts")
    private String trustedCaCerts = null;
    @SerializedName(value="additionalArguments")
    private List<String> additionalArguments = null;
    @SerializedName(value="hostCerts")
    private List<ApiHostCertInfo> hostCerts = null;
    @SerializedName(value="configureAllServices")
    private Boolean configureAllServices = null;

    public ApiGenerateCmcaArguments location(String location) {
        this.location = location;
        return this;
    }

    @Schema(example="/opt/cloudera/CMCA", description="The location on disk to store the CMCA directory. If there is already a CMCA created there, it will be backed up, and a new one will be created in its place.")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public ApiGenerateCmcaArguments customCA(Boolean customCA) {
        this.customCA = customCA;
        return this;
    }

    @Schema(example="false", description="Whether to generate an internal CMCA (false) or use user-provided certificates (true).  When set to true (user-provided certificates), the following other arguments must be given: * cmHostCert * cmHostKey * caCert * keystorePasswd * truststorePasswd")
    public Boolean isCustomCA() {
        return this.customCA;
    }

    public void setCustomCA(Boolean customCA) {
        this.customCA = customCA;
    }

    public ApiGenerateCmcaArguments interpretAsFilenames(Boolean interpretAsFilenames) {
        this.interpretAsFilenames = interpretAsFilenames;
        return this;
    }

    @Schema(example="true", description="Whether the following arguments are interpreted as filenames local to the Cloudera Manager host (true, default) or as the actual data for that argument: * cmHostCert * cmHostKey * caCert * keystorePasswd * truststorePasswd * trustedCaCerts * hostCerts.hostCert * hostCerts.hostKey  If HTTPS has not been enabled on the Cloudera Manager Admin Console and API, we *strongly* recommend that you pass the arguments as filenames local to the Cloudera Manager host (i.e. set to true) to avoid leaking sensitive information over the wire in plaintext.")
    public Boolean isInterpretAsFilenames() {
        return this.interpretAsFilenames;
    }

    public void setInterpretAsFilenames(Boolean interpretAsFilenames) {
        this.interpretAsFilenames = interpretAsFilenames;
    }

    public ApiGenerateCmcaArguments cmHostCert(String cmHostCert) {
        this.cmHostCert = cmHostCert;
        return this;
    }

    @Schema(example="host-cert.pem", description="The certificate for the CM host in PEM format. Only used if customCA == true.")
    public String getCmHostCert() {
        return this.cmHostCert;
    }

    public void setCmHostCert(String cmHostCert) {
        this.cmHostCert = cmHostCert;
    }

    public ApiGenerateCmcaArguments cmHostKey(String cmHostKey) {
        this.cmHostKey = cmHostKey;
        return this;
    }

    @Schema(example="host-key.pem", description="The private key for the CM host in PEM format. Only used if customCA == true.")
    public String getCmHostKey() {
        return this.cmHostKey;
    }

    public void setCmHostKey(String cmHostKey) {
        this.cmHostKey = cmHostKey;
    }

    public ApiGenerateCmcaArguments caCert(String caCert) {
        this.caCert = caCert;
        return this;
    }

    @Schema(example="ca-cert.pem", description="The certificate for the user-provided certificate authority in PEM format. Only used if customCA == true.")
    public String getCaCert() {
        return this.caCert;
    }

    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    public ApiGenerateCmcaArguments keystorePasswd(String keystorePasswd) {
        this.keystorePasswd = keystorePasswd;
        return this;
    }

    @Schema(example="keystore.pw.txt", description="The password used for all Auto-TLS keystores. Only used if customCA == true.")
    public String getKeystorePasswd() {
        return this.keystorePasswd;
    }

    public void setKeystorePasswd(String keystorePasswd) {
        this.keystorePasswd = keystorePasswd;
    }

    public ApiGenerateCmcaArguments truststorePasswd(String truststorePasswd) {
        this.truststorePasswd = truststorePasswd;
        return this;
    }

    @Schema(example="truststore.pw.txt", description="The password used for all Auto-TLS truststores. Only used if customCA == true.")
    public String getTruststorePasswd() {
        return this.truststorePasswd;
    }

    public void setTruststorePasswd(String truststorePasswd) {
        this.truststorePasswd = truststorePasswd;
    }

    public ApiGenerateCmcaArguments trustedCaCerts(String trustedCaCerts) {
        this.trustedCaCerts = trustedCaCerts;
        return this;
    }

    @Schema(example="cacerts.pem", description="A list of CA certificates that will be imported into the Auto-TLS truststore and distributed to all hosts.")
    public String getTrustedCaCerts() {
        return this.trustedCaCerts;
    }

    public void setTrustedCaCerts(String trustedCaCerts) {
        this.trustedCaCerts = trustedCaCerts;
    }

    public ApiGenerateCmcaArguments additionalArguments(List<String> additionalArguments) {
        this.additionalArguments = additionalArguments;
        return this;
    }

    public ApiGenerateCmcaArguments addAdditionalArgumentsItem(String additionalArgumentsItem) {
        if (this.additionalArguments == null) {
            this.additionalArguments = new ArrayList<String>();
        }
        this.additionalArguments.add(additionalArgumentsItem);
        return this;
    }

    @Schema(example="--override", description="A list of additional arguments that can be passed to the certificate manager")
    public List<String> getAdditionalArguments() {
        return this.additionalArguments;
    }

    public void setAdditionalArguments(List<String> additionalArguments) {
        this.additionalArguments = additionalArguments;
    }

    public ApiGenerateCmcaArguments hostCerts(List<ApiHostCertInfo> hostCerts) {
        this.hostCerts = hostCerts;
        return this;
    }

    public ApiGenerateCmcaArguments addHostCertsItem(ApiHostCertInfo hostCertsItem) {
        if (this.hostCerts == null) {
            this.hostCerts = new ArrayList<ApiHostCertInfo>();
        }
        this.hostCerts.add(hostCertsItem);
        return this;
    }

    @Schema(description="A list of HostCertInfo objects, which associate a hostname with the corresponding certificate and private key. Only used if customCA == true.")
    public List<ApiHostCertInfo> getHostCerts() {
        return this.hostCerts;
    }

    public void setHostCerts(List<ApiHostCertInfo> hostCerts) {
        this.hostCerts = hostCerts;
    }

    public ApiGenerateCmcaArguments configureAllServices(Boolean configureAllServices) {
        this.configureAllServices = configureAllServices;
        return this;
    }

    @Schema(description="Whether to configure all existing services to use Auto-TLS. Defaults to false.  If false, only MGMT services will be configured to use Auto-TLS. Use the cluster-level ConfigureAutoTlsServices command to configure Auto-TLS services for a single cluster only.  All future services will be configured to use Auto-TLS regardless of this setting.")
    public Boolean isConfigureAllServices() {
        return this.configureAllServices;
    }

    public void setConfigureAllServices(Boolean configureAllServices) {
        this.configureAllServices = configureAllServices;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiGenerateCmcaArguments apiGenerateCmcaArguments = (ApiGenerateCmcaArguments)o;
        return Objects.equals(this.location, apiGenerateCmcaArguments.location) && Objects.equals(this.customCA, apiGenerateCmcaArguments.customCA) && Objects.equals(this.interpretAsFilenames, apiGenerateCmcaArguments.interpretAsFilenames) && Objects.equals(this.cmHostCert, apiGenerateCmcaArguments.cmHostCert) && Objects.equals(this.cmHostKey, apiGenerateCmcaArguments.cmHostKey) && Objects.equals(this.caCert, apiGenerateCmcaArguments.caCert) && Objects.equals(this.keystorePasswd, apiGenerateCmcaArguments.keystorePasswd) && Objects.equals(this.truststorePasswd, apiGenerateCmcaArguments.truststorePasswd) && Objects.equals(this.trustedCaCerts, apiGenerateCmcaArguments.trustedCaCerts) && Objects.equals(this.additionalArguments, apiGenerateCmcaArguments.additionalArguments) && Objects.equals(this.hostCerts, apiGenerateCmcaArguments.hostCerts) && Objects.equals(this.configureAllServices, apiGenerateCmcaArguments.configureAllServices) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.location, this.customCA, this.interpretAsFilenames, this.cmHostCert, this.cmHostKey, this.caCert, this.keystorePasswd, this.truststorePasswd, this.trustedCaCerts, this.additionalArguments, this.hostCerts, this.configureAllServices, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiGenerateCmcaArguments {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    customCA: ").append(this.toIndentedString(this.customCA)).append("\n");
        sb.append("    interpretAsFilenames: ").append(this.toIndentedString(this.interpretAsFilenames)).append("\n");
        sb.append("    cmHostCert: ").append(this.toIndentedString(this.cmHostCert)).append("\n");
        sb.append("    cmHostKey: ").append(this.toIndentedString(this.cmHostKey)).append("\n");
        sb.append("    caCert: ").append(this.toIndentedString(this.caCert)).append("\n");
        sb.append("    keystorePasswd: ").append(this.toIndentedString(this.keystorePasswd)).append("\n");
        sb.append("    truststorePasswd: ").append(this.toIndentedString(this.truststorePasswd)).append("\n");
        sb.append("    trustedCaCerts: ").append(this.toIndentedString(this.trustedCaCerts)).append("\n");
        sb.append("    additionalArguments: ").append(this.toIndentedString(this.additionalArguments)).append("\n");
        sb.append("    hostCerts: ").append(this.toIndentedString(this.hostCerts)).append("\n");
        sb.append("    configureAllServices: ").append(this.toIndentedString(this.configureAllServices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

