/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.io.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.io.internal.InternalFilterOutputStream;
import org.apache.logging.log4j.io.internal.InternalOutputStream;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class InternalPrintStream
extends PrintStream {
    public InternalPrintStream(ExtendedLogger logger, boolean autoFlush, Charset charset, String fqcn, Level level, Marker marker) throws UnsupportedEncodingException {
        super((OutputStream)new InternalOutputStream(logger, level, marker, InternalPrintStream.ensureNonNull(charset), fqcn), autoFlush, InternalPrintStream.ensureNonNull(charset).name());
    }

    public InternalPrintStream(OutputStream out, boolean autoFlush, Charset charset, ExtendedLogger logger, String fqcn, Level level, Marker marker) throws UnsupportedEncodingException {
        super((OutputStream)new InternalFilterOutputStream(out, InternalPrintStream.ensureNonNull(charset), logger, fqcn, level, marker), autoFlush, InternalPrintStream.ensureNonNull(charset).name());
    }

    private static Charset ensureNonNull(Charset charset) {
        return charset == null ? Charset.defaultCharset() : charset;
    }

    @Override
    public InternalPrintStream append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public InternalPrintStream append(CharSequence csq) {
        super.append(csq);
        return this;
    }

    @Override
    public InternalPrintStream append(CharSequence csq, int start, int end) {
        super.append(csq, start, end);
        return this;
    }

    @Override
    public boolean checkError() {
        return super.checkError();
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void flush() {
        super.flush();
    }

    @Override
    public InternalPrintStream format(Locale l, String format, Object ... args) {
        super.format(l, format, args);
        return this;
    }

    @Override
    public InternalPrintStream format(String format, Object ... args) {
        super.format(format, args);
        return this;
    }

    @Override
    public void print(boolean b) {
        super.print(b);
    }

    @Override
    public void print(char c) {
        super.print(c);
    }

    @Override
    public void print(char[] s) {
        super.print(s);
    }

    @Override
    public void print(double d) {
        super.print(d);
    }

    @Override
    public void print(float f) {
        super.print(f);
    }

    @Override
    public void print(int i) {
        super.print(i);
    }

    @Override
    public void print(long l) {
        super.print(l);
    }

    @Override
    public void print(Object obj) {
        super.print(obj);
    }

    @Override
    public void print(String s) {
        super.print(s);
    }

    @Override
    public InternalPrintStream printf(Locale l, String format, Object ... args) {
        super.printf(l, format, args);
        return this;
    }

    @Override
    public InternalPrintStream printf(String format, Object ... args) {
        super.printf(format, args);
        return this;
    }

    @Override
    public void println() {
        super.println();
    }

    @Override
    public void println(boolean x) {
        super.println(x);
    }

    @Override
    public void println(char x) {
        super.println(x);
    }

    @Override
    public void println(char[] x) {
        super.println(x);
    }

    @Override
    public void println(double x) {
        super.println(x);
    }

    @Override
    public void println(float x) {
        super.println(x);
    }

    @Override
    public void println(int x) {
        super.println(x);
    }

    @Override
    public void println(long x) {
        super.println(x);
    }

    @Override
    public void println(Object x) {
        super.println(x);
    }

    @Override
    public void println(String x) {
        super.println(x);
    }

    public String toString() {
        return "{stream=" + this.out + '}';
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        super.write(b, off, len);
    }

    @Override
    public void write(int b) {
        super.write(b);
    }
}

